/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.Authentication;
import io.deephaven.client.impl.BearerHandler;
import java.util.Objects;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClientMiddleware;

class BearerMiddlewear
implements FlightClientMiddleware {
    private final BearerHandler bearerHandler;

    BearerMiddlewear(BearerHandler bearerHandler) {
        this.bearerHandler = Objects.requireNonNull(bearerHandler);
    }

    public void onBeforeSendingHeaders(CallHeaders outgoingHeaders) {
        outgoingHeaders.insert(Authentication.AUTHORIZATION_HEADER.name(), this.bearerHandler.authenticationValue());
    }

    public void onHeadersReceived(CallHeaders incomingHeaders) {
        String lastBearerValue = null;
        for (String authenticationValue : incomingHeaders.getAll(Authentication.AUTHORIZATION_HEADER.name())) {
            if (!authenticationValue.startsWith("Bearer ")) continue;
            lastBearerValue = authenticationValue;
        }
        if (lastBearerValue != null) {
            this.bearerHandler.setBearerToken(lastBearerValue.substring("Bearer ".length()));
        }
    }

    public void onCallCompleted(CallStatus status) {
    }
}

