/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.FieldAdapter;
import io.deephaven.client.impl.VectorHelper;
import io.deephaven.qst.array.Array;
import io.deephaven.qst.array.BooleanArray;
import io.deephaven.qst.array.ByteArray;
import io.deephaven.qst.array.CharArray;
import io.deephaven.qst.array.DoubleArray;
import io.deephaven.qst.array.FloatArray;
import io.deephaven.qst.array.GenericArray;
import io.deephaven.qst.array.IntArray;
import io.deephaven.qst.array.LongArray;
import io.deephaven.qst.array.PrimitiveArray;
import io.deephaven.qst.array.ShortArray;
import io.deephaven.qst.column.Column;
import io.deephaven.qst.type.ArrayType;
import io.deephaven.qst.type.BoxedBooleanType;
import io.deephaven.qst.type.BoxedByteType;
import io.deephaven.qst.type.BoxedCharType;
import io.deephaven.qst.type.BoxedDoubleType;
import io.deephaven.qst.type.BoxedFloatType;
import io.deephaven.qst.type.BoxedIntType;
import io.deephaven.qst.type.BoxedLongType;
import io.deephaven.qst.type.BoxedShortType;
import io.deephaven.qst.type.BoxedType;
import io.deephaven.qst.type.CustomType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.InstantType;
import io.deephaven.qst.type.StringType;
import io.deephaven.qst.type.Type;
import java.time.Instant;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.pojo.Field;

public class FieldVectorAdapter
implements Array.Visitor<FieldVector>,
PrimitiveArray.Visitor<FieldVector> {
    private final String name;
    private final BufferAllocator allocator;

    public static FieldVector of(Column<?> column, BufferAllocator allocator) {
        return FieldVectorAdapter.of(column.name(), column.array(), allocator);
    }

    public static FieldVector of(String name, Array<?> array, BufferAllocator allocator) {
        return (FieldVector)array.walk((Array.Visitor)new FieldVectorAdapter(name, allocator));
    }

    private FieldVectorAdapter(String name, BufferAllocator allocator) {
        this.name = Objects.requireNonNull(name);
        this.allocator = Objects.requireNonNull(allocator);
    }

    public FieldVector visit(PrimitiveArray<?> primitive) {
        return (FieldVector)primitive.walk((PrimitiveArray.Visitor)this);
    }

    public FieldVector visit(final GenericArray<?> generic) {
        return (FieldVector)generic.componentType().walk((GenericType.Visitor)new GenericType.Visitor<FieldVector>(){

            public FieldVector visit(BoxedType<?> boxedType) {
                return (FieldVector)boxedType.walk((BoxedType.Visitor)new BoxedType.Visitor<FieldVector>(){

                    public FieldVector visit(BoxedBooleanType booleanType) {
                        return FieldVectorAdapter.this.visitBooleanArray((GenericArray<Boolean>)generic.cast((GenericType)booleanType));
                    }

                    public FieldVector visit(BoxedByteType byteType) {
                        return FieldVectorAdapter.this.visitByteArray((GenericArray<Byte>)generic.cast((GenericType)byteType));
                    }

                    public FieldVector visit(BoxedCharType charType) {
                        return FieldVectorAdapter.this.visitCharacterArray((GenericArray<Character>)generic.cast((GenericType)charType));
                    }

                    public FieldVector visit(BoxedShortType shortType) {
                        return FieldVectorAdapter.this.visitShortArray((GenericArray<Short>)generic.cast((GenericType)shortType));
                    }

                    public FieldVector visit(BoxedIntType intType) {
                        return FieldVectorAdapter.this.visitIntegerArray((GenericArray<Integer>)generic.cast((GenericType)intType));
                    }

                    public FieldVector visit(BoxedLongType longType) {
                        return FieldVectorAdapter.this.visitLongArray((GenericArray<Long>)generic.cast((GenericType)longType));
                    }

                    public FieldVector visit(BoxedFloatType floatType) {
                        return FieldVectorAdapter.this.visitFloatArray((GenericArray<Float>)generic.cast((GenericType)floatType));
                    }

                    public FieldVector visit(BoxedDoubleType doubleType) {
                        return FieldVectorAdapter.this.visitDoubleArray((GenericArray<Double>)generic.cast((GenericType)doubleType));
                    }
                });
            }

            public FieldVector visit(StringType stringType) {
                return FieldVectorAdapter.this.visitStringArray((GenericArray<String>)generic.cast((GenericType)stringType));
            }

            public FieldVector visit(InstantType instantType) {
                return FieldVectorAdapter.this.visitInstantArray((GenericArray<Instant>)generic.cast((GenericType)instantType));
            }

            public FieldVector visit(ArrayType<?, ?> arrayType) {
                if (arrayType.componentType().equals(Type.find(Byte.TYPE))) {
                    return FieldVectorAdapter.this.visitByteVectorArray(generic.cast(arrayType));
                }
                throw new UnsupportedOperationException();
            }

            public FieldVector visit(CustomType<?> customType) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public FieldVector visit(ByteArray byteArray) {
        Field field = FieldAdapter.byteField(this.name);
        TinyIntVector vector = new TinyIntVector(field, this.allocator);
        VectorHelper.fill(vector, byteArray.values(), 0, byteArray.size());
        return vector;
    }

    public FieldVector visit(BooleanArray booleanArray) {
        Field field = FieldAdapter.booleanField(this.name);
        BitVector vector = new BitVector(field, this.allocator);
        VectorHelper.fill(vector, booleanArray, 0, booleanArray.size());
        return vector;
    }

    public FieldVector visit(CharArray charArray) {
        Field field = FieldAdapter.charField(this.name);
        UInt2Vector vector = new UInt2Vector(field, this.allocator);
        VectorHelper.fill(vector, charArray.values(), 0, charArray.size());
        return vector;
    }

    public FieldVector visit(ShortArray shortArray) {
        Field field = FieldAdapter.shortField(this.name);
        SmallIntVector vector = new SmallIntVector(field, this.allocator);
        VectorHelper.fill(vector, shortArray.values(), 0, shortArray.size());
        return vector;
    }

    public FieldVector visit(IntArray intArray) {
        Field field = FieldAdapter.intField(this.name);
        IntVector vector = new IntVector(field, this.allocator);
        VectorHelper.fill(vector, intArray.values(), 0, intArray.size());
        return vector;
    }

    public FieldVector visit(LongArray longArray) {
        Field field = FieldAdapter.longField(this.name);
        BigIntVector vector = new BigIntVector(field, this.allocator);
        VectorHelper.fill(vector, longArray.values(), 0, longArray.size());
        return vector;
    }

    public FieldVector visit(FloatArray floatArray) {
        Field field = FieldAdapter.floatField(this.name);
        Float4Vector vector = new Float4Vector(field, this.allocator);
        VectorHelper.fill(vector, floatArray.values(), 0, floatArray.size());
        return vector;
    }

    public FieldVector visit(DoubleArray doubleArray) {
        Field field = FieldAdapter.doubleField(this.name);
        Float8Vector vector = new Float8Vector(field, this.allocator);
        VectorHelper.fill(vector, doubleArray.values(), 0, doubleArray.size());
        return vector;
    }

    FieldVector visitBooleanArray(GenericArray<Boolean> array) {
        Field field = FieldAdapter.booleanField(this.name);
        BitVector vector = new BitVector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitByteArray(GenericArray<Byte> array) {
        Field field = FieldAdapter.byteField(this.name);
        TinyIntVector vector = new TinyIntVector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitCharacterArray(GenericArray<Character> array) {
        Field field = FieldAdapter.charField(this.name);
        UInt2Vector vector = new UInt2Vector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitShortArray(GenericArray<Short> array) {
        Field field = FieldAdapter.shortField(this.name);
        SmallIntVector vector = new SmallIntVector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitIntegerArray(GenericArray<Integer> array) {
        Field field = FieldAdapter.intField(this.name);
        IntVector vector = new IntVector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitLongArray(GenericArray<Long> array) {
        Field field = FieldAdapter.longField(this.name);
        BigIntVector vector = new BigIntVector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitFloatArray(GenericArray<Float> array) {
        Field field = FieldAdapter.floatField(this.name);
        Float4Vector vector = new Float4Vector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitDoubleArray(GenericArray<Double> array) {
        Field field = FieldAdapter.doubleField(this.name);
        Float8Vector vector = new Float8Vector(field, this.allocator);
        VectorHelper.fill(vector, array.values());
        return vector;
    }

    FieldVector visitStringArray(GenericArray<String> stringArray) {
        Field field = FieldAdapter.stringField(this.name);
        VarCharVector vector = new VarCharVector(field, this.allocator);
        VectorHelper.fill(vector, stringArray.values());
        return vector;
    }

    FieldVector visitByteVectorArray(GenericArray<?> byteVectorArray) {
        Field field = FieldAdapter.byteVectorField(this.name);
        VarBinaryVector vector = new VarBinaryVector(field, this.allocator);
        VectorHelper.fill(vector, byteVectorArray.values());
        return vector;
    }

    FieldVector visitInstantArray(GenericArray<Instant> instantArray) {
        Field field = FieldAdapter.instantField(this.name);
        TimeStampNanoTZVector vector = new TimeStampNanoTZVector(field, this.allocator);
        VectorHelper.fill(vector, instantArray.values());
        return vector;
    }
}

