/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.ExportId;
import io.deephaven.client.impl.FlightClientHelper;
import io.deephaven.client.impl.HasPathId;
import io.deephaven.client.impl.HasTicketId;
import io.deephaven.client.impl.Session;
import io.deephaven.client.impl.SessionImpl;
import io.deephaven.client.impl.SessionMiddleware;
import io.deephaven.client.impl.TableHandle;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.flight.util.SchemaHelper;
import io.deephaven.qst.table.NewTable;
import io.deephaven.qst.table.TableSpec;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightGrpcUtilsExtension;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSession
implements AutoCloseable {
    protected final SessionImpl session;
    protected final FlightClient client;

    public static FlightSession of(SessionImpl session, BufferAllocator incomingAllocator, ManagedChannel channel) {
        FlightClient client = FlightGrpcUtilsExtension.createFlightClientWithSharedChannel(incomingAllocator, channel, Collections.singletonList(new SessionMiddleware(session)));
        return new FlightSession(session, client);
    }

    protected FlightSession(SessionImpl session, FlightClient client) {
        this.session = Objects.requireNonNull(session);
        this.client = Objects.requireNonNull(client);
    }

    public Session session() {
        return this.session;
    }

    public Schema schema(TableHandle handle) {
        return SchemaHelper.schema((ExportedTableCreationResponse)handle.response());
    }

    public Schema schema(HasPathId pathId) {
        return FlightClientHelper.getSchema(this.client, pathId, new CallOption[0]).getSchema();
    }

    public FlightStream stream(HasTicketId ticketId) {
        return FlightClientHelper.get(this.client, ticketId, new CallOption[0]);
    }

    public FlightClient.ExchangeReaderWriter startExchange(FlightDescriptor descriptor, CallOption ... options) {
        return this.client.doExchange(descriptor, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableHandle putExport(NewTable table, BufferAllocator allocator) throws TableHandle.TableHandleException, InterruptedException {
        ExportId exportId = this.putExportManual(table, allocator);
        try {
            TableHandle tableHandle = this.session.execute((TableSpec)exportId.ticketId().table());
            return tableHandle;
        }
        finally {
            this.release(exportId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableHandle putExport(FlightStream input) throws TableHandle.TableHandleException, InterruptedException {
        ExportId export = this.putExportManual(input);
        try {
            TableHandle tableHandle = this.session.execute((TableSpec)export.ticketId().table());
            return tableHandle;
        }
        finally {
            this.release(export);
        }
    }

    public ExportId putExportManual(NewTable table, BufferAllocator allocator) {
        ExportId exportTicket = this.session.newExportId();
        try {
            this.put((HasPathId)exportTicket, table, allocator);
        }
        catch (Throwable t) {
            this.session.release(exportTicket);
            throw t;
        }
        return exportTicket;
    }

    public ExportId putExportManual(FlightStream input) {
        ExportId exportTicket = this.session.newExportId();
        try {
            this.put((HasPathId)exportTicket, input);
        }
        catch (Throwable t) {
            this.session.release(exportTicket);
            throw t;
        }
        return exportTicket;
    }

    public void put(HasPathId pathId, FlightStream input) {
        FlightClientHelper.put(this.client, pathId, input, new CallOption[0]);
    }

    public void put(HasPathId pathId, NewTable table, BufferAllocator allocator) {
        FlightClientHelper.put(this.client, pathId, table, allocator, new CallOption[0]);
    }

    public CompletableFuture<Void> addToInputTable(HasTicketId destination, FlightStream source) {
        ExportId exportId = this.putExportManual(source);
        CompletableFuture future = this.session.addToInputTable(destination, (HasTicketId)exportId);
        future.whenComplete((result, error) -> this.release(exportId));
        return future;
    }

    public CompletableFuture<Void> addToInputTable(HasTicketId destination, NewTable source, BufferAllocator allocator) {
        ExportId exportId = this.putExportManual(source, allocator);
        CompletableFuture future = this.session.addToInputTable(destination, (HasTicketId)exportId);
        future.whenComplete((result, error) -> this.release(exportId));
        return future;
    }

    public CompletableFuture<Void> deleteFromInputTable(HasTicketId destination, FlightStream source) {
        ExportId exportId = this.putExportManual(source);
        CompletableFuture future = this.session.deleteFromInputTable(destination, (HasTicketId)exportId);
        future.whenComplete((result, error) -> this.release(exportId));
        return future;
    }

    public CompletableFuture<Void> deleteFromInputTable(HasTicketId destination, NewTable source, BufferAllocator allocator) {
        ExportId exportId = this.putExportManual(source, allocator);
        CompletableFuture future = this.session.deleteFromInputTable(destination, (HasTicketId)exportId);
        future.whenComplete((result, error) -> this.release(exportId));
        return future;
    }

    public CompletableFuture<Void> release(ExportId exportId) {
        return this.session.release(exportId);
    }

    public Iterable<FlightInfo> list() {
        return this.client.listFlights(Criteria.ALL, new CallOption[0]);
    }

    @Override
    public void close() throws InterruptedException {
        this.client.close();
    }
}

