/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.internal.log;

import com.google.auto.service.AutoService;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.pool.Pool;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.internal.log.LoggerFactorySingleCache;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.log.LogEntryPool;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.log.impl.DynamicDelayedLogEntryPoolImpl;
import io.deephaven.io.log.impl.DynamicLogBufferPoolImpl;
import io.deephaven.io.log.impl.LogOutputCsvImpl;
import io.deephaven.io.log.impl.LogSinkImpl;
import io.deephaven.io.logger.Logger;
import io.deephaven.io.logger.LoggerImpl;
import io.deephaven.io.logger.LoggerTimeSource;
import io.deephaven.io.logger.NullLoggerImpl;
import java.util.TimeZone;

@AutoService(value={LoggerFactory.class})
public final class LoggerFactoryFile
extends LoggerFactorySingleCache {
    private static String getPath() {
        return System.getProperty("io.deephaven.internal.log.LoggerFactoryFile.path", "log.txt");
    }

    private static boolean append() {
        return Boolean.parseBoolean(System.getProperty("io.deephaven.internal.log.LoggerFactoryFile.append", "true"));
    }

    private static boolean showLevel() {
        return Boolean.parseBoolean(System.getProperty("io.deephaven.internal.log.LoggerFactoryFile.showLevel", "true"));
    }

    private static boolean showThreadName() {
        return Boolean.parseBoolean(System.getProperty("io.deephaven.internal.log.LoggerFactoryFile.showThreadName", "true"));
    }

    private static TimeZone timeZone() {
        String timeZone = System.getProperty("io.deephaven.internal.log.LoggerFactoryFile.timeZone");
        return timeZone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZone);
    }

    private static LogLevel level() {
        return LogLevel.valueOf((String)System.getProperty("io.deephaven.internal.log.LoggerFactoryFile.level", "INFO").toUpperCase());
    }

    public final Logger createInternal() {
        DynamicLogBufferPoolImpl bufferPool = new DynamicLogBufferPoolImpl("LogBufferPool", 1024, 1024);
        DynamicDelayedLogEntryPoolImpl logEntryPool = new DynamicDelayedLogEntryPoolImpl("LogEntryPool", 32768, (LoggerTimeSource)new NullLoggerImpl.NullLoggerTimeSource());
        String header = null;
        LogSinkImpl logSink = new LogSinkImpl(LoggerFactoryFile.getPath(), Integer.MAX_VALUE, null, (Pool)logEntryPool, LoggerFactoryFile.append(), (LogOutput)new LogOutputCsvImpl((LogBufferPool)bufferPool), header, null);
        String prefix = null;
        NullLoggerImpl.NullLoggerTimeSource timeSource = new NullLoggerImpl.NullLoggerTimeSource();
        return new LoggerImpl((LogEntryPool)logEntryPool, (LogSink)logSink, prefix, LoggerFactoryFile.level(), (LoggerTimeSource)timeSource, LoggerFactoryFile.timeZone(), LoggerFactoryFile.showLevel(), LoggerFactoryFile.showThreadName());
    }
}

