/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.internal.log;

import com.google.auto.service.AutoService;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.internal.log.LoggerFactorySingleCache;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.logger.Logger;
import io.deephaven.io.logger.StreamLoggerImpl;
import java.io.OutputStream;
import java.io.PrintStream;

@AutoService(value={LoggerFactory.class})
public final class LoggerFactoryStream
extends LoggerFactorySingleCache {
    private static PrintStream getStream() {
        String value = System.getProperty("io.deephaven.internal.log.LoggerFactoryStream.stream", "OUT");
        switch (value.toUpperCase()) {
            case "OUT": {
                return System.out;
            }
            case "ERR": {
                return System.err;
            }
        }
        throw new IllegalArgumentException("Unexpected stream " + value);
    }

    private static LogLevel getLevel() {
        return LogLevel.valueOf((String)System.getProperty("io.deephaven.internal.log.LoggerFactoryStream.level", "INFO"));
    }

    public final Logger createInternal() {
        return new StreamLoggerImpl((OutputStream)LoggerFactoryStream.getStream(), LoggerFactoryStream.getLevel());
    }
}

