/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.LogBufferGlobal;
import io.deephaven.io.logger.LogBufferRecord;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class LogBufferAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private LogBuffer logBuffer;
    private Encoder<ILoggingEvent> encoder;

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = Objects.requireNonNull(encoder);
    }

    public void start() {
        int errors = 0;
        if (this.encoder == null) {
            this.addStatus((Status)new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", (Object)this));
            ++errors;
        }
        this.logBuffer = LogBufferGlobal.getInstance().orElse(null);
        if (this.logBuffer == null) {
            this.addStatus((Status)new ErrorStatus("No global LogBuffer found for \"" + this.name + "\".", (Object)this));
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    protected void append(ILoggingEvent event) {
        if (event.getLevel() == Level.OFF) {
            return;
        }
        event.prepareForDeferredProcessing();
        LogBufferRecord record = new LogBufferRecord();
        record.setLevel(LogBufferAppender.adapt(event.getLevel()));
        record.setData(ByteBuffer.wrap(this.encoder.encode((Object)event)));
        record.setTimestampMicros(event.getTimeStamp() * 1000L);
        this.logBuffer.record(record);
    }

    private static LogLevel adapt(Level level) {
        switch (level.toInt()) {
            case -2147483648: 
            case 5000: {
                return LogLevel.TRACE;
            }
            case 10000: {
                return LogLevel.DEBUG;
            }
            case 20000: {
                return LogLevel.INFO;
            }
            case 30000: {
                return LogLevel.WARN;
            }
            case 40000: {
                return LogLevel.ERROR;
            }
        }
        throw new IllegalArgumentException("Unexpected level " + level + " " + level.toInt());
    }
}

