/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.parse;

import io.deephaven.base.verify.Assert;
import io.deephaven.io.logger.Logger;
import io.deephaven.lang.generated.BaseToken;
import io.deephaven.lang.generated.ChunkerAssign;
import io.deephaven.lang.generated.ChunkerDefaultVisitor;
import io.deephaven.lang.generated.ChunkerDocument;
import io.deephaven.lang.generated.ChunkerStatement;
import io.deephaven.lang.generated.Node;
import io.deephaven.lang.generated.ParseException;
import io.deephaven.lang.generated.SimpleNode;
import io.deephaven.lang.generated.Token;
import io.deephaven.lang.parse.LspTools;
import io.deephaven.proto.backplane.script.grpc.CompletionItem;
import io.deephaven.proto.backplane.script.grpc.DocumentRange;
import io.deephaven.proto.backplane.script.grpc.Position;
import io.deephaven.proto.backplane.script.grpc.PositionOrBuilder;
import io.deephaven.proto.backplane.script.grpc.TextEdit;
import io.deephaven.util.datastructures.CachingSupplier;
import io.deephaven.web.shared.fu.MappedIterable;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class ParsedDocument {
    private static final Comparator<SimpleNode> CMP = (a, b) -> {
        int cmp;
        if (a == b) {
            return 0;
        }
        Token aStart = a.jjtGetFirstToken();
        Token bStart = b.jjtGetFirstToken();
        if (b instanceof AnchorNode) {
            Assert.eqFalse((boolean)(a instanceof AnchorNode), (String)"You may only use one AnchorNode at a time");
            cmp = -bStart.compareTo(aStart);
        } else {
            cmp = aStart.compareTo(bStart);
        }
        if (cmp != 0) {
            return cmp;
        }
        Token aEnd = a.jjtGetLastToken();
        Token bEnd = b.jjtGetLastToken();
        cmp = b instanceof AnchorNode ? -bEnd.compareTo(aEnd) : aEnd.compareTo(bEnd);
        if (cmp != 0) {
            return cmp;
        }
        if (a.isChildOf((Node)b)) {
            return 1;
        }
        assert (b.isChildOf((Node)a)) : "Nodes occupying the same tokenspace were not in a parent-child relationship " + String.valueOf(a) + " does not contain " + String.valueOf(b) + " (or vice versa)";
        return -1;
    };
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\\r?\\n");
    private final ChunkerDocument doc;
    private final CachingSupplier<Set<ChunkerStatement>> statements;
    private final String src;
    private String errorSource;
    private ParseException error;
    private final Map<DocumentRange, Position.Builder> computedPositions;
    private final Map<String, List<ChunkerAssign>> assignments;

    public ParsedDocument(ChunkerDocument doc, String document) {
        this.doc = doc;
        this.src = document;
        this.computedPositions = new ConcurrentHashMap<DocumentRange, Position.Builder>(4);
        this.assignments = new ConcurrentHashMap<String, List<ChunkerAssign>>(12);
        this.statements = new CachingSupplier(() -> {
            final LinkedHashSet stmts = new LinkedHashSet();
            doc.childrenAccept(new ChunkerDefaultVisitor(){

                @Override
                public Object visitChunkerStatement(ChunkerStatement node, Object data) {
                    stmts.add(node);
                    return null;
                }
            }, null);
            return stmts;
        });
    }

    public Node findNode(int p) {
        if (this.doc.jjtGetFirstToken() == this.doc.jjtGetLastToken() && this.doc.jjtGetFirstToken().kind == 0) {
            return this.doc;
        }
        Node best = p >= this.doc.getEndIndex() ? this.findLast(this.doc, Math.max(0, Math.min(p - 1, this.doc.getEndIndex()))) : this.findDeepest(this.doc, Math.max(0, p));
        return best;
    }

    private Node findDeepest(Node best, int i) {
        Assert.leq((int)best.getStartIndex(), (String)"node.startIndex", (int)i);
        Assert.geq((int)best.getEndIndex(), (String)"node.endIndex", (int)i);
        int c = best.jjtGetNumChildren();
        while (c-- > 0) {
            Node child = best.jjtGetChild(c);
            if (!child.containsIndex(i) && (!(best instanceof ChunkerStatement) || i != child.getEndIndex())) continue;
            return this.findDeepest(child, i);
        }
        return best;
    }

    private Node findLast(Node best, int i) {
        Assert.leq((int)best.getStartIndex(), (String)"node.startIndex", (int)i);
        Assert.geq((int)best.getEndIndex(), (String)"node.endIndex", (int)i);
        int c = best.jjtGetNumChildren() - 1;
        if (c == -1) {
            return best;
        }
        Node child = best.jjtGetChild(c);
        if (child.getEndIndex() >= i) {
            if (child.jjtGetNumChildren() == 0) {
                return child;
            }
            return this.findLast(child, i);
        }
        return best;
    }

    public ChunkerDocument getDoc() {
        return this.doc;
    }

    public ParsedDocument withError(String src, ParseException e) {
        this.errorSource = src;
        this.error = e;
        return this;
    }

    public String getSource() {
        return this.errorSource == null ? this.src : this.errorSource;
    }

    public String getLastGoodSource() {
        return this.src;
    }

    public boolean isError() {
        return this.errorSource != null || this.error != null;
    }

    public void resetFailure() {
        this.errorSource = null;
        this.error = null;
    }

    public void logErrors(Logger log) {
        if (this.error != null) {
            log.warn((Object)"Invalid document; use trace logging for more details", (Throwable)this.error);
            log.trace((Object)this.errorSource);
        }
    }

    public String toString() {
        return "ParsedDocument{doc=" + String.valueOf(this.doc) + ", errorSource='" + this.errorSource + "', error=" + String.valueOf(this.error) + "}";
    }

    public Position.Builder findEditRange(DocumentRange replaceRange) {
        Token end = this.doc.jjtGetLastToken();
        assert (replaceRange.getEnd().getLine() < end.endLine);
        assert (replaceRange.getEnd().getCharacter() <= end.endColumn);
        return this.computedPositions.computeIfAbsent(replaceRange, r -> this.findFromNodes(replaceRange, this.doc));
    }

    private Position.Builder findFromNodes(DocumentRange replaceRange, Node startNode) {
        return this.findFromNodes(replaceRange, startNode, null);
    }

    private Position.Builder findFromNodes(DocumentRange replaceRange, Node startNode, Node endNode) {
        if (startNode.jjtGetNumChildren() == 0) {
            if (endNode != startNode) {
                endNode = this.refineEndNode(replaceRange, endNode == null ? startNode : endNode);
            }
            assert (this.startsBefore(startNode, replaceRange.getStart()));
            return this.findFromTokens(replaceRange, startNode.jjtGetFirstToken(), endNode.jjtGetFirstToken());
        }
        for (Node kid : MappedIterable.reversed(startNode.getChildren())) {
            if ((endNode == null || endNode == startNode) && this.startsBefore(kid, replaceRange.getEnd())) {
                endNode = kid;
            }
            if (!this.startsBefore(kid, replaceRange.getStart())) continue;
            return this.findFromNodes(replaceRange, kid, endNode);
        }
        if (endNode != startNode) {
            endNode = this.refineEndNode(replaceRange, endNode == null ? startNode : endNode);
        }
        return this.findFromTokens(replaceRange, startNode.jjtGetFirstToken(), endNode.jjtGetFirstToken());
    }

    private boolean startsBefore(Node kid, Position start) {
        return LspTools.lessOrEqual((PositionOrBuilder)kid.jjtGetFirstToken().positionStart(), (PositionOrBuilder)start);
    }

    private Node refineEndNode(DocumentRange replaceRange, Node endNode) {
        if (endNode.jjtGetNumChildren() == 0) {
            return endNode;
        }
        for (Node kid : MappedIterable.reversed(endNode.getChildren())) {
            if (!this.startsBefore(kid, replaceRange.getEnd())) continue;
            return this.refineEndNode(replaceRange, kid);
        }
        return endNode;
    }

    private Position.Builder findFromTokens(DocumentRange replaceRange, Token start, Token end) {
        Position.Builder startPos = start.positionStart();
        Position.Builder endPos = end.positionStart();
        assert (LspTools.greaterOrEqual((PositionOrBuilder)replaceRange.getStart(), (PositionOrBuilder)startPos));
        assert (LspTools.greaterOrEqual((PositionOrBuilder)replaceRange.getEnd(), (PositionOrBuilder)endPos));
        int startInd = this.findFromToken(replaceRange.getStart(), start, true);
        int endInd = this.findFromToken(replaceRange.getEnd(), end, false);
        return Position.newBuilder().setLine(startInd).setCharacter(endInd);
    }

    private int findFromToken(Position pos, Token tok, boolean start) {
        Token startTok = tok;
        if (start && tok.positionStart().equals(pos)) {
            return tok.tokenBegin;
        }
        if (!start && tok.positionEnd(true).equals(pos)) {
            return tok.tokenBegin + Math.min(1, tok.image.length());
        }
        while (tok.next != null) {
            if (tok.containsPosition((PositionOrBuilder)pos)) {
                int ind = tok.tokenBegin;
                Position.Builder candidate = tok.positionStart();
                String[] lines = NEW_LINE_PATTERN.split(tok.image);
                for (int linePos = 0; linePos < lines.length; ++linePos) {
                    String line = lines[linePos];
                    if (candidate.getLine() == pos.getLine()) {
                        return ind += pos.getCharacter() - candidate.getCharacter();
                    }
                    candidate.setLine(candidate.getLine() + 1);
                    candidate.setCharacter(0);
                    ind += line.length() + 1;
                }
                return ind;
            }
            tok = tok.next;
        }
        throw new IllegalArgumentException("Token " + String.valueOf(startTok) + " does not contain position " + String.valueOf(pos));
    }

    public void extendEnd(CompletionItem.Builder item, Position requested, Node node) {
        Token tok = node.findToken((PositionOrBuilder)item.getTextEditBuilder().getRangeBuilder().getEndBuilder());
        while (LspTools.lessThan((PositionOrBuilder)item.getTextEdit().getRange().getEnd(), (PositionOrBuilder)requested)) {
            if ((tok = this.extendEnd(tok, requested, item)) != null) continue;
            item.getTextEditBuilder().getRangeBuilder().setEnd(LspTools.plus(requested, 0, 1));
            break;
        }
    }

    private Token extendEnd(Token tok, Position requested, CompletionItem.Builder edit) {
        if (tok.beginLine == tok.endLine) {
            TextEdit.Builder textEdit = edit.getTextEditBuilder();
            int moved = LspTools.extend(textEdit.getRangeBuilder().getEndBuilder(), (PositionOrBuilder)tok.positionEnd());
            String txt = tok.image;
            textEdit.setText(textEdit.getText() + txt.substring(txt.length() - moved));
            edit.setTextEdit(textEdit);
            return tok.next;
        }
        throw new UnsupportedOperationException("Multi-line edits not supported yet; cannot extendEnd over " + String.valueOf(tok));
    }

    public Map<String, List<ChunkerAssign>> getAssignments() {
        return this.assignments;
    }

    private static class AnchorNode
    extends SimpleNode {
        AnchorNode(final int index) {
            super(-1);
            Token cheat = new Token(-1, ""){

                @Override
                public int compareTo(BaseToken o) {
                    if (o.getStartIndex() == index) {
                        return index - o.getEndIndex();
                    }
                    return index - o.getStartIndex();
                }
            };
            cheat.startIndex = index;
            cheat.endIndex = index;
            this.jjtSetFirstToken(cheat);
            this.jjtSetLastToken(cheat);
        }

        @Override
        public boolean containsIndex(int i) {
            return i == this.jjtGetFirstToken().startIndex;
        }
    }
}

