/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.web.shared.fu;

import io.deephaven.web.shared.fu.MappedIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;

public class LinkedIterable<T>
implements MappedIterable<T> {
    private final T head;
    private final UnaryOperator<T> next;
    private final boolean skipHead;
    private BiConsumer<T, T> remover;

    public LinkedIterable(final T head, final T tail, final boolean includeTail, final boolean strict, final UnaryOperator<T> next) {
        this(head, new UnaryOperator<T>(){
            boolean done;
            {
                this.done = head == tail;
            }

            @Override
            public T apply(T cur) {
                if (this.done) {
                    return null;
                }
                if (cur == tail) {
                    if (!includeTail) {
                        return null;
                    }
                    return cur;
                }
                Object find = next.apply(cur);
                if (strict && find == null) {
                    throw new IllegalStateException("Iterable starting at " + head + " did not end with " + tail);
                }
                if (find == tail) {
                    this.done = true;
                }
                return find;
            }
        }, false);
        if (strict) {
            if (head == null) {
                throw new NullPointerException("iterable start cannot be null!");
            }
            if (tail == null) {
                throw new NullPointerException("iterable end cannot be null!");
            }
        }
    }

    public LinkedIterable(T head, UnaryOperator<T> next) {
        this(head, next, false);
    }

    public LinkedIterable(T head, UnaryOperator<T> next, boolean skipHead) {
        this.head = head;
        this.next = next;
        this.skipHead = skipHead;
    }

    @Override
    public Iterator<T> iterator() {
        Itr itr = new Itr();
        itr.node = this.head;
        itr.computed = !this.skipHead;
        return itr;
    }

    public LinkedIterable<T> setRemover(BiConsumer<T, T> remover) {
        this.remover = remover;
        return this;
    }

    private final class Itr
    implements Iterator<T> {
        T node;
        T prev;
        boolean computed;
        boolean removed;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            if (!this.computed) {
                this.computed = true;
                Object newNode = LinkedIterable.this.next.apply(this.node);
                if (this.node == newNode) {
                    return false;
                }
                this.prev = this.node;
                this.node = newNode;
            }
            return this.node != null;
        }

        @Override
        public T next() {
            this.removed = false;
            if (!this.computed) {
                this.hasNext();
            }
            this.computed = false;
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            return this.node;
        }

        @Override
        public void remove() {
            if (LinkedIterable.this.remover != null) {
                if (this.removed) {
                    throw new IllegalStateException("Cannot call remove() more than once per next()");
                }
                this.removed = true;
                if (this.node == null) {
                    throw new IllegalStateException("Cannot remove() before next()");
                }
                LinkedIterable.this.remover.accept(this.prev, this.node);
            } else {
                Iterator.super.remove();
            }
        }
    }
}

