/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.web.shared.fu;

import io.deephaven.web.shared.fu.ReverseListIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface MappedIterable<T>
extends Iterable<T> {
    public static final MappedIterable EMPTY = () -> new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("empty");
        }
    };

    public static <T> MappedIterable<T> of(Iterable<T> source) {
        return source instanceof MappedIterable ? (MappedIterable)source : source::iterator;
    }

    public static <T> MappedIterable<T> empty() {
        return EMPTY;
    }

    default public MappedIterable<T> filterNonNull() {
        return this.filter(Objects::nonNull);
    }

    default public MappedIterable<T> filter(final Function<T, Boolean> filter) {
        return () -> {
            final Iterator source = this.iterator();
            return new Iterator<T>(){
                Object next;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    while (source.hasNext()) {
                        Object candidate = source.next();
                        if (!((Boolean)filter.apply(candidate)).booleanValue()) continue;
                        this.next = candidate;
                        return true;
                    }
                    return false;
                }

                @Override
                public T next() {
                    try {
                        Object object = this.next;
                        return object;
                    }
                    finally {
                        this.next = null;
                    }
                }

                @Override
                public void remove() {
                    source.remove();
                }
            };
        };
    }

    default public boolean anyMatch(Predicate<T> test) {
        for (Object t : this) {
            if (!test.test(t)) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(Predicate<T> test) {
        for (Object t : this) {
            if (!test.test(t)) continue;
            return false;
        }
        return true;
    }

    default public boolean allMatch(Predicate<T> test) {
        for (Object t : this) {
            if (test.test(t)) continue;
            return false;
        }
        return true;
    }

    default public <V> MappedIterable<V> mapped(final Function<T, V> mapper) {
        return () -> {
            final Iterator source = this.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return source.hasNext();
                }

                @Override
                public V next() {
                    Object result = mapper.apply(source.next());
                    return result;
                }

                @Override
                public void remove() {
                    source.remove();
                }
            };
        };
    }

    default public MappedIterable<T> plus(Iterable<T> more) {
        return () -> {
            final Iterator mine = this.iterator();
            final Iterator yours = more.iterator();
            return new Iterator<T>(){
                Iterator delegate;
                {
                    this.delegate = mine;
                }

                @Override
                public boolean hasNext() {
                    if (this.delegate.hasNext()) {
                        return true;
                    }
                    this.delegate = yours;
                    return this.delegate.hasNext();
                }

                @Override
                public T next() {
                    return this.delegate.next();
                }

                @Override
                public void remove() {
                    this.delegate.remove();
                }
            };
        };
    }

    default public T first() {
        Iterator itr = this.iterator();
        if (itr.hasNext()) {
            return itr.next();
        }
        throw new NoSuchElementException(this + " is empty");
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public static <T> MappedIterable<T> reversed(List<T> items) {
        return new ReverseListIterable<T>(items);
    }

    default public MappedIterable<T> reverse() {
        return () -> new Iterator<T>(){
            private final ListIterator itr;
            {
                ArrayList items = new ArrayList();
                MappedIterable.this.forEach(items::add);
                this.itr = items.listIterator(items.size());
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasPrevious();
            }

            @Override
            public T next() {
                return this.itr.previous();
            }
        };
    }
}

