/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.app;

import com.sun.management.GarbageCollectionNotificationInfo;
import io.deephaven.app.GcNotificationPublisher;
import io.deephaven.app.GcPoolsPublisher;
import io.deephaven.appmode.ApplicationState;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.liveness.LivenessScope;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.sources.ring.RingTableTools;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.stream.StreamPublisher;
import io.deephaven.stream.StreamToBlinkTableAdapter;
import io.deephaven.util.SafeCloseable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public final class GcApplication
implements ApplicationState.Factory,
NotificationListener {
    private static final String APP_ID = "io.deephaven.app.GcApplication";
    private static final String APP_NAME = "Garbage-Collection Application";
    private static final String NOTIFICATION_INFO = "notification_info";
    private static final String NOTIFICATION_INFO_STATS = "notification_info_stats";
    private static final String NOTIFICATION_INFO_RING = "notification_info_ring";
    private static final String POOLS = "pools";
    private static final String POOLS_STATS = "pools_stats";
    private static final String ENABLED = "io.deephaven.app.GcApplication.enabled";
    private static final String NOTIFICATION_INFO_ENABLED = "io.deephaven.app.GcApplication.notification_info.enabled";
    private static final String NOTIFICATION_INFO_STATS_ENABLED = "io.deephaven.app.GcApplication.notification_info_stats.enabled";
    private static final String NOTIFICATION_INFO_RING_ENABLED = "io.deephaven.app.GcApplication.notification_info_ring.enabled";
    private static final String POOLS_ENABLED = "io.deephaven.app.GcApplication.pools.enabled";
    private static final String POOLS_STATS_ENABLED = "io.deephaven.app.GcApplication.pools_stats.enabled";
    private GcNotificationPublisher notificationInfoPublisher;
    private GcPoolsPublisher poolsPublisher;
    private LivenessScope scope;

    public static boolean enabled() {
        return "true".equalsIgnoreCase(System.getProperty(ENABLED));
    }

    public static boolean notificationInfoEnabled() {
        return "true".equalsIgnoreCase(System.getProperty(NOTIFICATION_INFO_ENABLED, "true"));
    }

    public static boolean notificationInfoStatsEnabled() {
        return "true".equalsIgnoreCase(System.getProperty(NOTIFICATION_INFO_STATS_ENABLED, "true"));
    }

    public static int notificationInfoRingSize() {
        return Integer.getInteger(NOTIFICATION_INFO_RING_ENABLED, 1024);
    }

    public static boolean poolsEnabled() {
        return "true".equalsIgnoreCase(System.getProperty(POOLS_ENABLED, "true"));
    }

    public static boolean poolStatsEnabled() {
        return "true".equalsIgnoreCase(System.getProperty(POOLS_STATS_ENABLED, "true"));
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        try {
            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
            this.notificationInfoPublisher.add(info);
            this.poolsPublisher.add(info.getGcInfo());
        }
        catch (Throwable t) {
            this.notificationInfoPublisher.acceptFailure(t);
            this.poolsPublisher.acceptFailure(t);
            try {
                this.remove();
            }
            catch (ListenerNotFoundException e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    public ApplicationState create(ApplicationState.Listener listener) {
        ApplicationState state = new ApplicationState(listener, APP_ID, APP_NAME);
        if (!GcApplication.enabled()) {
            return state;
        }
        boolean notificationInfoEnabled = GcApplication.notificationInfoEnabled();
        boolean poolsEnabled = GcApplication.poolsEnabled();
        if (!GcApplication.notificationInfoEnabled() && !GcApplication.poolsEnabled()) {
            return state;
        }
        this.scope = new LivenessScope();
        try (SafeCloseable ignored = LivenessScopeStack.open((LivenessScope)this.scope, (boolean)false);){
            if (notificationInfoEnabled) {
                this.setNotificationInfo(state);
            }
            if (poolsEnabled) {
                this.setPools(state);
            }
        }
        this.install();
        return state;
    }

    private void setNotificationInfo(ApplicationState state) {
        int ringSize;
        this.notificationInfoPublisher = new GcNotificationPublisher();
        StreamToBlinkTableAdapter adapter = new StreamToBlinkTableAdapter(GcNotificationPublisher.definition(), (StreamPublisher)this.notificationInfoPublisher, (UpdateSourceRegistrar)ExecutionContext.getContext().getUpdateGraph(), NOTIFICATION_INFO);
        Table notificationInfo = adapter.table();
        state.setField(NOTIFICATION_INFO, (Object)notificationInfo);
        if (GcApplication.notificationInfoStatsEnabled()) {
            state.setField(NOTIFICATION_INFO_STATS, (Object)GcNotificationPublisher.stats(notificationInfo));
        }
        if ((ringSize = GcApplication.notificationInfoRingSize()) > 0) {
            state.setField(NOTIFICATION_INFO_RING, (Object)RingTableTools.of((Table)notificationInfo, (int)ringSize));
        }
    }

    private void setPools(ApplicationState state) {
        this.poolsPublisher = new GcPoolsPublisher();
        StreamToBlinkTableAdapter adapter = new StreamToBlinkTableAdapter(GcPoolsPublisher.definition(), (StreamPublisher)this.poolsPublisher, (UpdateSourceRegistrar)ExecutionContext.getContext().getUpdateGraph(), POOLS);
        Table pools = adapter.table();
        state.setField(POOLS, (Object)pools);
        if (GcApplication.poolStatsEnabled()) {
            state.setField(POOLS_STATS, (Object)GcPoolsPublisher.stats(pools));
        }
    }

    private void install() {
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(bean instanceof NotificationBroadcaster)) continue;
            ((NotificationBroadcaster)((Object)bean)).addNotificationListener(this, GcNotificationFilter.INSTANCE, null);
        }
    }

    private void remove() throws ListenerNotFoundException {
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(bean instanceof NotificationBroadcaster)) continue;
            ((NotificationBroadcaster)((Object)bean)).removeNotificationListener(this);
        }
    }

    private static enum GcNotificationFilter implements NotificationFilter
    {
        INSTANCE;


        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return "com.sun.management.gc.notification".equals(notification.getType());
        }
    }
}

