/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.app;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.util.PercentileOutput;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.stream.StreamChunkUtils;
import io.deephaven.stream.StreamConsumer;
import io.deephaven.stream.StreamPublisher;
import io.deephaven.time.DateTimeUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class GcNotificationPublisher
implements StreamPublisher {
    private static final TableDefinition DEFINITION = TableDefinition.of((ColumnDefinition[])new ColumnDefinition[]{ColumnDefinition.ofLong((String)"Id"), ColumnDefinition.ofTime((String)"Start"), ColumnDefinition.ofTime((String)"End"), ColumnDefinition.ofString((String)"GcName"), ColumnDefinition.ofString((String)"GcAction"), ColumnDefinition.ofString((String)"GcCause"), ColumnDefinition.ofLong((String)"Reclaimed")});
    private static final int CHUNK_SIZE = 2048;
    private final long vmStartMillis = ManagementFactory.getRuntimeMXBean().getStartTime();
    private WritableChunk<Values>[] chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)2048);
    private StreamConsumer consumer;

    public static TableDefinition definition() {
        return DEFINITION;
    }

    public static Table stats(Table notificationInfo) {
        return (Table)((Table)notificationInfo.updateView(new String[]{"Duration=(End-Start)/1000000000"})).aggBy(Arrays.asList(Aggregation.AggCount((String)"Count"), Aggregation.AggSum((String[])new String[]{"DurationTotal=Duration", "ReclaimedTotal=Reclaimed"}), Aggregation.AggMax((String[])new String[]{"DurationMax=Duration"}), Aggregation.AggAvg((String[])new String[]{"DurationAvg=Duration", "ReclaimedAvg=Reclaimed"}), Aggregation.AggApproxPct((String)"Reclaimed", (PercentileOutput[])new PercentileOutput[]{PercentileOutput.of((double)0.5, (String)"ReclaimedP_50")}), Aggregation.AggApproxPct((String)"Duration", (PercentileOutput[])new PercentileOutput[]{PercentileOutput.of((double)0.5, (String)"DurationP_50"), PercentileOutput.of((double)0.9, (String)"DurationP_90"), PercentileOutput.of((double)0.95, (String)"DurationP_95"), PercentileOutput.of((double)0.99, (String)"DurationP_99")}), Aggregation.AggLast((String[])new String[]{"LastId=Id", "LastStart=Start", "LastEnd=End", "LastReclaimed=Reclaimed"})), new String[]{"GcName", "GcAction", "GcCause"});
    }

    GcNotificationPublisher() {
    }

    public void register(@NotNull StreamConsumer consumer) {
        if (this.consumer != null) {
            throw new IllegalStateException("Can not register multiple StreamConsumers.");
        }
        this.consumer = Objects.requireNonNull(consumer);
    }

    public synchronized void add(GarbageCollectionNotificationInfo gcNotification) {
        GcInfo gcInfo = gcNotification.getGcInfo();
        this.chunks[0].asWritableLongChunk().add(gcInfo.getId());
        this.chunks[1].asWritableLongChunk().add(DateTimeUtils.millisToNanos((long)(this.vmStartMillis + gcInfo.getStartTime())));
        this.chunks[2].asWritableLongChunk().add(DateTimeUtils.millisToNanos((long)(this.vmStartMillis + gcInfo.getEndTime())));
        this.chunks[3].asWritableObjectChunk().add((Object)gcNotification.getGcName());
        this.chunks[4].asWritableObjectChunk().add((Object)gcNotification.getGcAction());
        this.chunks[5].asWritableObjectChunk().add((Object)gcNotification.getGcCause());
        long usedBefore = gcNotification.getGcInfo().getMemoryUsageBeforeGc().values().stream().mapToLong(MemoryUsage::getUsed).sum();
        long usedAfter = gcNotification.getGcInfo().getMemoryUsageAfterGc().values().stream().mapToLong(MemoryUsage::getUsed).sum();
        long reclaimed = usedBefore - usedAfter;
        this.chunks[6].asWritableLongChunk().add(reclaimed);
        if (this.chunks[0].size() == 2048) {
            this.flushInternal();
        }
    }

    public synchronized void flush() {
        if (this.chunks[0].size() == 0) {
            return;
        }
        this.flushInternal();
    }

    private void flushInternal() {
        this.consumer.accept(this.chunks);
        this.chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)2048);
    }

    public void acceptFailure(Throwable e) {
        this.consumer.acceptFailure(e);
    }

    public void shutdown() {
    }
}

