/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.app;

import com.sun.management.GcInfo;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.util.PercentileOutput;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.stream.StreamChunkUtils;
import io.deephaven.stream.StreamConsumer;
import io.deephaven.stream.StreamPublisher;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class GcPoolsPublisher
implements StreamPublisher {
    private static final TableDefinition DEFINITION = TableDefinition.of((ColumnDefinition[])new ColumnDefinition[]{ColumnDefinition.ofLong((String)"Id"), ColumnDefinition.ofString((String)"Name"), ColumnDefinition.ofLong((String)"BeforeInit"), ColumnDefinition.ofLong((String)"BeforeUsed"), ColumnDefinition.ofLong((String)"BeforeCommitted"), ColumnDefinition.ofLong((String)"BeforeMax"), ColumnDefinition.ofLong((String)"AfterInit"), ColumnDefinition.ofLong((String)"AfterUsed"), ColumnDefinition.ofLong((String)"AfterCommitted"), ColumnDefinition.ofLong((String)"AfterMax")});
    private static final int INITIAL_CHUNK_SIZE = 2048;
    private int chunkSize = 2048;
    private WritableChunk<Values>[] chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)this.chunkSize);
    private StreamConsumer consumer;
    private boolean isFirst = true;

    public static TableDefinition definition() {
        return DEFINITION;
    }

    public static Table stats(Table pools) {
        return (Table)((Table)pools.updateView(new String[]{"UsedReclaimed=BeforeUsed-AfterUsed", "CommittedReclaimed=BeforeCommitted-AfterCommitted"})).aggBy(Arrays.asList(Aggregation.AggCount((String)"Count"), Aggregation.AggSum((String[])new String[]{"UsedReclaimedTotal=UsedReclaimed", "CommittedReclaimedTotal=CommittedReclaimed"}), Aggregation.AggAvg((String[])new String[]{"UsedReclaimedAvg=UsedReclaimed", "CommittedReclaimedAvg=CommittedReclaimed"}), Aggregation.AggApproxPct((String)"UsedReclaimed", (PercentileOutput[])new PercentileOutput[]{PercentileOutput.of((double)0.5, (String)"UsedReclaimedP_50")}), Aggregation.AggApproxPct((String)"CommittedReclaimed", (PercentileOutput[])new PercentileOutput[]{PercentileOutput.of((double)0.5, (String)"CommittedReclaimedP_50")}), Aggregation.AggLast((String[])new String[]{"BeforeInit", "BeforeUsed", "BeforeCommitted", "BeforeMax", "AfterInit", "AfterUsed", "AfterCommitted", "AfterMax"})), new String[]{"Name"});
    }

    GcPoolsPublisher() {
    }

    public void register(@NotNull StreamConsumer consumer) {
        if (this.consumer != null) {
            throw new IllegalStateException("Can not register multiple StreamConsumers.");
        }
        this.consumer = Objects.requireNonNull(consumer);
    }

    public synchronized void add(GcInfo info) {
        Map<String, MemoryUsage> afterMap = info.getMemoryUsageAfterGc();
        int poolSize = afterMap.size();
        int initialSize = this.chunks[0].size();
        if (initialSize + poolSize >= this.chunkSize) {
            this.maybeFlushAndGrow(initialSize, poolSize);
        }
        for (Map.Entry<String, MemoryUsage> e : info.getMemoryUsageBeforeGc().entrySet()) {
            String poolName = e.getKey();
            MemoryUsage before = e.getValue();
            MemoryUsage after = afterMap.get(poolName);
            if (!this.isFirst && GcPoolsPublisher.equals(before, after)) continue;
            this.chunks[0].asWritableLongChunk().add(info.getId());
            this.chunks[1].asWritableObjectChunk().add((Object)poolName);
            this.chunks[2].asWritableLongChunk().add(GcPoolsPublisher.negativeOneToNullLong(before.getInit()));
            this.chunks[3].asWritableLongChunk().add(before.getUsed());
            this.chunks[4].asWritableLongChunk().add(before.getCommitted());
            this.chunks[5].asWritableLongChunk().add(GcPoolsPublisher.negativeOneToNullLong(before.getMax()));
            this.chunks[6].asWritableLongChunk().add(GcPoolsPublisher.negativeOneToNullLong(after.getInit()));
            this.chunks[7].asWritableLongChunk().add(after.getUsed());
            this.chunks[8].asWritableLongChunk().add(after.getCommitted());
            this.chunks[9].asWritableLongChunk().add(GcPoolsPublisher.negativeOneToNullLong(after.getMax()));
        }
        this.isFirst = false;
        if (initialSize + 2 * poolSize >= this.chunkSize) {
            this.flushInternal();
        }
    }

    public synchronized void flush() {
        if (this.chunks[0].size() == 0) {
            return;
        }
        this.flushInternal();
    }

    private void maybeFlushAndGrow(int initialSize, int poolSize) {
        if (initialSize > 0) {
            this.consumer.accept(this.chunks);
        }
        this.chunkSize = Math.max(this.chunkSize, poolSize);
        this.chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)this.chunkSize);
    }

    private void flushInternal() {
        this.consumer.accept(this.chunks);
        this.chunks = StreamChunkUtils.makeChunksForDefinition((TableDefinition)DEFINITION, (int)this.chunkSize);
    }

    public void acceptFailure(Throwable e) {
        this.consumer.acceptFailure(e);
    }

    public void shutdown() {
    }

    private static boolean equals(MemoryUsage before, MemoryUsage after) {
        return before.getUsed() == after.getUsed() && before.getCommitted() == after.getCommitted() && before.getMax() == after.getMax() && before.getInit() == after.getInit();
    }

    private static long negativeOneToNullLong(long x) {
        return x == -1L ? Long.MIN_VALUE : x;
    }
}

