/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.partitionedtable;

import com.google.auto.service.AutoService;
import com.google.protobuf.ByteString;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.extensions.barrage.util.BarrageUtil;
import io.deephaven.plugin.type.ObjectType;
import io.deephaven.plugin.type.ObjectTypeBase;
import io.deephaven.proto.backplane.grpc.PartitionedTableDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;

@AutoService(value={ObjectType.class})
public class PartitionedTableTypePlugin
extends ObjectTypeBase {
    public String name() {
        return "PartitionedTable";
    }

    public boolean isType(Object object) {
        return object instanceof PartitionedTable;
    }

    public void writeCompatibleObjectTo(ObjectType.Exporter exporter, Object object, OutputStream out) throws IOException {
        PartitionedTable partitionedTable = (PartitionedTable)object;
        exporter.reference((Object)partitionedTable.table(), false, true);
        ByteString schemaWrappedInMessage = BarrageUtil.schemaBytesFromTableDefinition((TableDefinition)partitionedTable.constituentDefinition(), Collections.emptyMap());
        PartitionedTableDescriptor result = PartitionedTableDescriptor.newBuilder().addAllKeyColumnNames((Iterable)partitionedTable.keyColumnNames()).setUniqueKeys(partitionedTable.uniqueKeys()).setConstituentDefinitionSchema(schemaWrappedInMessage).setConstituentColumnName(partitionedTable.constituentColumnName()).setConstituentChangesPermitted(partitionedTable.constituentChangesPermitted()).build();
        result.writeTo(out);
    }
}

