/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto.util;

import com.google.protobuf.ByteStringAccess;
import com.google.rpc.Code;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.util.ByteHelper;
import io.deephaven.proto.util.Exceptions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class ExportTicketHelper {
    public static final byte TICKET_PREFIX = 101;
    public static final String FLIGHT_DESCRIPTOR_ROUTE = "export";

    public static Ticket wrapExportIdInTicket(int exportId) {
        byte[] dest = ExportTicketHelper.exportIdToBytes(exportId);
        return Ticket.newBuilder().setTicket(ByteStringAccess.wrap(dest)).build();
    }

    public static TableReference tableReference(int exportId) {
        return TableReference.newBuilder().setTicket(ExportTicketHelper.wrapExportIdInTicket(exportId)).build();
    }

    public static int ticketToExportId(Ticket ticket, String logId) {
        return ExportTicketHelper.ticketToExportIdInternal(ticket.getTicket().asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN), logId);
    }

    public static int ticketToExportId(ByteBuffer ticket, String logId) {
        if (ticket == null) {
            throw Exceptions.statusRuntimeException(Code.FAILED_PRECONDITION, "Could not resolve '" + logId + "': ticket not supplied");
        }
        return ticket.order() == ByteOrder.LITTLE_ENDIAN ? ExportTicketHelper.ticketToExportIdInternal(ticket, logId) : ExportTicketHelper.ticketToExportIdInternal(ticket.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN), logId);
    }

    public static Ticket wrapExportIdInTicket(ByteBuffer ticket) {
        ByteBuffer lebb = ticket.order() == ByteOrder.LITTLE_ENDIAN ? ticket : ticket.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        return Ticket.newBuilder().setTicket(ByteStringAccess.wrap(lebb)).build();
    }

    public static String toReadableString(Ticket ticket, String logId) {
        return ExportTicketHelper.toReadableString(ticket.getTicket().asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN), logId);
    }

    public static String toReadableString(TableReference tableReference, String logId) {
        switch (tableReference.getRefCase()) {
            case TICKET: {
                return ExportTicketHelper.toReadableString(tableReference.getTicket(), logId);
            }
            case BATCH_OFFSET: {
                return String.format("batchOffset[%d]", tableReference.getBatchOffset());
            }
        }
        throw Exceptions.statusRuntimeException(Code.FAILED_PRECONDITION, "Could not resolve '" + logId + "': unexpected TableReference type '" + (Object)((Object)tableReference.getRefCase()) + "'");
    }

    public static String toReadableString(ByteBuffer ticket, String logId) {
        return ExportTicketHelper.toReadableString(ExportTicketHelper.ticketToExportId(ticket, logId));
    }

    public static String toReadableString(int exportId) {
        return "export/" + exportId;
    }

    public static List<String> exportIdToPath(int exportId) {
        return Arrays.asList(FLIGHT_DESCRIPTOR_ROUTE, Integer.toString(exportId));
    }

    public static byte[] exportIdToBytes(int exportId) {
        byte[] dest = new byte[]{101, (byte)exportId, (byte)(exportId >>> 8), (byte)(exportId >>> 16), (byte)(exportId >>> 24)};
        return dest;
    }

    public static int ticketToExportIdInternal(ByteBuffer ticket, String logId) {
        if (ticket.order() != ByteOrder.LITTLE_ENDIAN) {
            throw Exceptions.statusRuntimeException(Code.FAILED_PRECONDITION, "Could not resolve ticket '" + logId + "': ticket is not in LITTLE_ENDIAN order");
        }
        int pos = ticket.position();
        if (ticket.remaining() == 0) {
            throw Exceptions.statusRuntimeException(Code.FAILED_PRECONDITION, "Could not resolve ticket '" + logId + "': ticket was not provided");
        }
        if (ticket.remaining() != 5 || ticket.get(pos) != 101) {
            throw Exceptions.statusRuntimeException(Code.FAILED_PRECONDITION, "Could not resolve ticket '" + logId + "': found 0x" + ByteHelper.byteBufToHex(ticket) + " (hex)");
        }
        return ticket.getInt(pos + 1);
    }
}

