/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.ImmutableColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.Selectable;
import io.deephaven.api.SortColumn;
import io.deephaven.api.agg.Pair;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.util.NameValidator;
import io.deephaven.api.value.Value;
import java.io.Serializable;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class ColumnName
implements Selectable,
Value,
Expression,
Pair,
JoinMatch,
JoinAddition,
Serializable {
    public static boolean isValidParsedColumnName(String value) {
        return NameValidator.isValidColumnName(value.trim());
    }

    public static ColumnName of(String name) {
        return ImmutableColumnName.of(name);
    }

    public static ColumnName parse(String value) {
        return ColumnName.of(value.trim());
    }

    @Value.Parameter
    public abstract String name();

    public final SortColumn asc() {
        return SortColumn.asc(this);
    }

    public final SortColumn desc() {
        return SortColumn.desc(this);
    }

    @Override
    public final <V extends Expression.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Override
    public final <V extends Value.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkName() {
        NameValidator.validateColumnName(this.name());
    }

    @Override
    public final ColumnName newColumn() {
        return this;
    }

    @Override
    public final Expression expression() {
        return this;
    }

    @Override
    public final ColumnName input() {
        return this;
    }

    @Override
    public final ColumnName output() {
        return this;
    }

    @Override
    public final ColumnName left() {
        return this;
    }

    @Override
    public final ColumnName right() {
        return this;
    }

    @Override
    public final ColumnName existingColumn() {
        return this;
    }
}

