/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.ColumnName;
import io.deephaven.api.RawString;
import io.deephaven.api.SelectableImpl;
import io.deephaven.api.expression.Expression;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface Selectable
extends Serializable {
    public static Selectable of(ColumnName newColumn, Expression expression) {
        if (newColumn.equals(expression)) {
            return newColumn;
        }
        return SelectableImpl.of(newColumn, expression);
    }

    public static Selectable parse(String x) {
        int ix = x.indexOf(61);
        if (ix < 0) {
            return ColumnName.parse(x);
        }
        if (ix + 1 == x.length()) {
            throw new IllegalArgumentException(String.format("Unable to parse formula '%s', expected form '<newColumn>=<expression>'", x));
        }
        if (x.charAt(ix + 1) == '=') {
            throw new IllegalArgumentException(String.format("Unable to parse formula '%s', expected form '<newColumn>=<expression>'", x));
        }
        return SelectableImpl.of(ColumnName.parse(x.substring(0, ix)), RawString.of(x.substring(ix + 1)));
    }

    public static List<Selectable> from(String ... values) {
        return Selectable.from(Arrays.asList(values));
    }

    public static List<Selectable> from(Collection<String> values) {
        return values.stream().map(Selectable::parse).collect(Collectors.toList());
    }

    public ColumnName newColumn();

    public Expression expression();
}

