/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.ImmutableSelectableImpl;
import io.deephaven.api.Selectable;
import io.deephaven.api.expression.Expression;
import java.io.Serializable;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
abstract class SelectableImpl
implements Selectable,
Serializable {
    SelectableImpl() {
    }

    public static SelectableImpl of(ColumnName newColumn, Expression expression) {
        return ImmutableSelectableImpl.of(newColumn, expression);
    }

    @Override
    @Value.Parameter
    public abstract ColumnName newColumn();

    @Override
    @Value.Parameter
    public abstract Expression expression();

    @Value.Check
    final void checkExpressionNotSameColumn() {
        if (this.expression().equals(this.newColumn())) {
            throw new IllegalArgumentException("Should not construct SelectableImpl with expression() equal to newColumn(), use the ColumnName directly");
        }
    }
}

