/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.RawString;
import io.deephaven.api.Selectable;
import io.deephaven.api.agg.Pair;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterAnd;
import io.deephaven.api.filter.FilterCondition;
import io.deephaven.api.filter.FilterIsNotNull;
import io.deephaven.api.filter.FilterIsNull;
import io.deephaven.api.filter.FilterNot;
import io.deephaven.api.filter.FilterOr;
import io.deephaven.api.value.Value;
import java.util.Objects;
import java.util.stream.Collectors;

public class Strings {
    public static String of(ColumnName columnName) {
        return columnName.name();
    }

    public static String of(RawString rawString) {
        return rawString.value();
    }

    public static String of(FilterCondition condition) {
        String lhs = Strings.of(condition.lhs());
        String rhs = Strings.of(condition.rhs());
        switch (condition.operator()) {
            case LESS_THAN: {
                return String.format("%s < %s", lhs, rhs);
            }
            case LESS_THAN_OR_EQUAL: {
                return String.format("%s <= %s", lhs, rhs);
            }
            case GREATER_THAN: {
                return String.format("%s > %s", lhs, rhs);
            }
            case GREATER_THAN_OR_EQUAL: {
                return String.format("%s >= %s", lhs, rhs);
            }
            case EQUALS: {
                return String.format("%s == %s", lhs, rhs);
            }
            case NOT_EQUALS: {
                return String.format("%s != %s", lhs, rhs);
            }
        }
        throw new IllegalStateException("Unexpected condition operator: " + (Object)((Object)condition.operator()));
    }

    public static String of(FilterNot not) {
        return String.format("!(%s)", Strings.of(not.filter()));
    }

    public static String of(FilterIsNull isNull) {
        return String.format("isNull(%s)", Strings.of(isNull.column()));
    }

    public static String of(FilterIsNotNull isNotNull) {
        return String.format("!isNull(%s)", Strings.of(isNotNull.column()));
    }

    public static String of(FilterOr filterOr) {
        return filterOr.filters().stream().map(Strings::of).collect(Collectors.joining(") || (", "(", ")"));
    }

    public static String of(FilterAnd filterAnd) {
        return filterAnd.filters().stream().map(Strings::of).collect(Collectors.joining(") && (", "(", ")"));
    }

    public static String of(Pair pair) {
        if (pair.input().equals(pair.output())) {
            return Strings.of(pair.output());
        }
        return String.format("%s=%s", Strings.of(pair.output()), Strings.of(pair.input()));
    }

    public static String of(JoinMatch match) {
        if (match.left().equals(match.right())) {
            return Strings.of(match.left());
        }
        return String.format("%s==%s", Strings.of(match.left()), Strings.of(match.right()));
    }

    public static String of(JoinAddition addition) {
        if (addition.newColumn().equals(addition.existingColumn())) {
            return Strings.of(addition.newColumn());
        }
        return String.format("%s=%s", Strings.of(addition.newColumn()), Strings.of(addition.existingColumn()));
    }

    public static String of(Selectable selectable) {
        String lhs = Strings.of(selectable.newColumn());
        if (selectable.newColumn().equals(selectable.expression())) {
            return lhs;
        }
        String rhs = selectable.expression().walk(new UniversalAdapter()).getOut();
        return String.format("%s=%s", lhs, rhs);
    }

    public static String of(Expression expression) {
        return expression.walk(new UniversalAdapter()).getOut();
    }

    public static String of(Filter filter) {
        return filter.walk(new UniversalAdapter()).getOut();
    }

    public static String of(Value value) {
        UniversalAdapter universalAdapter = new UniversalAdapter();
        value.walk(universalAdapter);
        return universalAdapter.getOut();
    }

    private static class UniversalAdapter
    implements Filter.Visitor,
    Expression.Visitor,
    Value.Visitor {
        private String out;

        private UniversalAdapter() {
        }

        public String getOut() {
            return Objects.requireNonNull(this.out);
        }

        @Override
        public void visit(ColumnName name) {
            this.out = Strings.of(name);
        }

        @Override
        public void visit(RawString rawString) {
            this.out = Strings.of(rawString);
        }

        @Override
        public void visit(FilterCondition condition) {
            this.out = Strings.of(condition);
        }

        @Override
        public void visit(FilterIsNull isNull) {
            this.out = Strings.of(isNull);
        }

        @Override
        public void visit(FilterIsNotNull isNotNull) {
            this.out = Strings.of(isNotNull);
        }

        @Override
        public void visit(FilterNot not) {
            this.out = Strings.of(not);
        }

        @Override
        public void visit(FilterOr ors) {
            this.out = Strings.of(ors);
        }

        @Override
        public void visit(FilterAnd ands) {
            this.out = Strings.of(ands);
        }

        @Override
        public void visit(Value value) {
            this.out = Strings.of(value);
        }

        @Override
        public void visit(long x) {
            this.out = Long.toString(x);
        }
    }
}

