/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.Aggregations;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Count;
import io.deephaven.api.agg.FirstRowKey;
import io.deephaven.api.agg.LastRowKey;
import io.deephaven.api.agg.Pair;
import io.deephaven.api.agg.Partition;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.util.PercentileOutput;
import io.deephaven.api.agg.util.Sentinel;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiFunction;

public interface Aggregation
extends Serializable {
    public static ColumnAggregation of(AggSpec spec, String pair) {
        return ColumnAggregation.of(spec, Pair.parse(pair));
    }

    public static Aggregation of(AggSpec spec, String ... pairs) {
        if (pairs.length == 1) {
            return Aggregation.of(spec, pairs[0]);
        }
        ColumnAggregations.Builder builder = ColumnAggregations.builder().spec(spec);
        for (String pair : pairs) {
            builder.addPairs(Pair.parse(pair));
        }
        return builder.build();
    }

    public static Aggregation of(Aggregation ... aggregations) {
        if (aggregations.length == 1) {
            return aggregations[0];
        }
        return Aggregations.builder().addAggregations(aggregations).build();
    }

    @SafeVarargs
    public static <INPUT_TYPE> Aggregation of(BiFunction<ColumnName, INPUT_TYPE, ColumnAggregation> columnAggFactory, String inputColumn, INPUT_TYPE ... inputs) {
        ColumnName inputColumnName = ColumnName.of(inputColumn);
        if (inputs.length == 1) {
            return columnAggFactory.apply(inputColumnName, inputs[0]);
        }
        Aggregations.Builder builder = Aggregations.builder();
        for (INPUT_TYPE input : inputs) {
            builder.addAggregations((Aggregation)columnAggFactory.apply(inputColumnName, input));
        }
        return builder.build();
    }

    public static Aggregation AggAbsSum(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.absSum(), pairs);
    }

    public static Aggregation AggApproxPct(double percentile, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.approximatePercentile(percentile), pairs);
    }

    public static Aggregation AggApproxPct(double percentile, double compression, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.approximatePercentile(percentile, compression), pairs);
    }

    public static Aggregation AggApproxPct(String inputColumn, PercentileOutput ... percentileOutputs) {
        BiFunction<ColumnName, PercentileOutput, ColumnAggregation> aggFactory = (ic, po) -> ColumnAggregation.of((AggSpec)AggSpec.approximatePercentile(po.percentile()), Pair.of(ic, po.output()));
        return Aggregation.of(aggFactory, inputColumn, percentileOutputs);
    }

    public static Aggregation AggApproxPct(String inputColumn, double compression, PercentileOutput ... percentileOutputs) {
        BiFunction<ColumnName, PercentileOutput, ColumnAggregation> aggFactory = (ic, po) -> ColumnAggregation.of((AggSpec)AggSpec.approximatePercentile(po.percentile(), compression), Pair.of(ic, po.output()));
        return Aggregation.of(aggFactory, inputColumn, percentileOutputs);
    }

    public static Aggregation AggAvg(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.avg(), pairs);
    }

    public static Count AggCount(String resultColumn) {
        return Count.of(resultColumn);
    }

    public static Aggregation AggCountDistinct(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.countDistinct(), pairs);
    }

    public static Aggregation AggCountDistinct(boolean countNulls, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.countDistinct(countNulls), pairs);
    }

    public static Aggregation AggDistinct(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.distinct(), pairs);
    }

    public static Aggregation AggDistinct(boolean includeNulls, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.distinct(includeNulls), pairs);
    }

    public static Aggregation AggFirst(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.first(), pairs);
    }

    public static FirstRowKey AggFirstRowKey(String resultColumn) {
        return FirstRowKey.of(resultColumn);
    }

    public static Aggregation AggFormula(String formula, String paramToken, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.formula(formula, paramToken), pairs);
    }

    public static Aggregation AggFreeze(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.freeze(), pairs);
    }

    public static Aggregation AggGroup(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.group(), pairs);
    }

    public static Aggregation AggLast(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.last(), pairs);
    }

    public static LastRowKey AggLastRowKey(String resultColumn) {
        return LastRowKey.of(resultColumn);
    }

    public static Aggregation AggMax(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.max(), pairs);
    }

    public static Aggregation AggMed(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.median(), pairs);
    }

    public static Aggregation AggMed(boolean average, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.median(average), pairs);
    }

    public static Aggregation AggMin(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.min(), pairs);
    }

    public static Partition AggPartition(String resultColumn) {
        return Partition.of(resultColumn);
    }

    public static Partition AggPartition(String resultColumn, boolean includeGroupByColumns) {
        return Partition.of(resultColumn, includeGroupByColumns);
    }

    public static Aggregation AggPct(double percentile, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.percentile(percentile), pairs);
    }

    public static Aggregation AggPct(double percentile, boolean average, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.percentile(percentile, average), pairs);
    }

    public static Aggregation AggPct(String inputColumn, PercentileOutput ... percentileOutputs) {
        BiFunction<ColumnName, PercentileOutput, ColumnAggregation> aggFactory = (ic, po) -> ColumnAggregation.of((AggSpec)AggSpec.percentile(po.percentile()), Pair.of(ic, po.output()));
        return Aggregation.of(aggFactory, inputColumn, percentileOutputs);
    }

    public static Aggregation AggPct(String inputColumn, boolean average, PercentileOutput ... percentileOutputs) {
        BiFunction<ColumnName, PercentileOutput, ColumnAggregation> aggFactory = (ic, po) -> ColumnAggregation.of((AggSpec)AggSpec.percentile(po.percentile(), average), Pair.of(ic, po.output()));
        return Aggregation.of(aggFactory, inputColumn, percentileOutputs);
    }

    public static Aggregation AggSortedFirst(String sortColumn, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.sortedFirst(sortColumn), pairs);
    }

    public static Aggregation AggSortedFirst(Collection<? extends String> sortColumns, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.sortedFirst(sortColumns), pairs);
    }

    public static Aggregation AggSortedLast(String sortColumn, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.sortedLast(sortColumn), pairs);
    }

    public static Aggregation AggSortedLast(Collection<? extends String> sortColumns, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.sortedLast(sortColumns), pairs);
    }

    public static Aggregation AggStd(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.std(), pairs);
    }

    public static Aggregation AggSum(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.sum(), pairs);
    }

    public static Aggregation AggTDigest(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.tDigest(), pairs);
    }

    public static Aggregation AggTDigest(double compression, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.tDigest(compression), pairs);
    }

    public static Aggregation AggUnique(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.unique(), pairs);
    }

    public static Aggregation AggUnique(boolean includeNulls, String ... pairs) {
        return Aggregation.AggUnique(includeNulls, Sentinel.of(), pairs);
    }

    public static Aggregation AggUnique(boolean includeNulls, Sentinel nonUniqueSentinel, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.unique(includeNulls, nonUniqueSentinel.value()), pairs);
    }

    public static Aggregation AggVar(String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.var(), pairs);
    }

    public static Aggregation AggWAvg(String weightColumn, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.wavg(weightColumn), pairs);
    }

    public static Aggregation AggWSum(String weightColumn, String ... pairs) {
        return Aggregation.of((AggSpec)AggSpec.wsum(weightColumn), pairs);
    }

    public static PercentileOutput PctOut(double percentile, String outputColumn) {
        return PercentileOutput.of(percentile, outputColumn);
    }

    public static Sentinel Sentinel(Object value) {
        return Sentinel.of(value);
    }

    public static Sentinel Sentinel() {
        return Sentinel.of();
    }

    public <V extends Visitor> V walk(V var1);

    public static interface Visitor {
        public void visit(Aggregations var1);

        public void visit(ColumnAggregation var1);

        public void visit(ColumnAggregations var1);

        public void visit(Count var1);

        public void visit(FirstRowKey var1);

        public void visit(LastRowKey var1);

        public void visit(Partition var1);
    }
}

