/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.Aggregations;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Count;
import io.deephaven.api.agg.FirstRowKey;
import io.deephaven.api.agg.LastRowKey;
import io.deephaven.api.agg.Pair;
import io.deephaven.api.agg.Partition;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AggregationDescriptions
implements Aggregation.Visitor {
    private final Map<String, String> out = new LinkedHashMap<String, String>();

    public static Map<String, String> of(Aggregation aggregation) {
        return aggregation.walk(new AggregationDescriptions()).getOut();
    }

    public static Map<String, String> of(Collection<? extends Aggregation> aggregations) {
        AggregationDescriptions descriptions = new AggregationDescriptions();
        aggregations.forEach(a -> a.walk(descriptions));
        return descriptions.getOut();
    }

    Map<String, String> getOut() {
        return this.out;
    }

    @Override
    public void visit(Aggregations aggregations) {
        aggregations.aggregations().forEach(a -> a.walk(this));
    }

    @Override
    public void visit(ColumnAggregation columnAgg) {
        this.visitColumnAgg(columnAgg.pair(), columnAgg.spec().description());
    }

    @Override
    public void visit(ColumnAggregations columnAggs) {
        String specDescription = columnAggs.spec().description();
        columnAggs.pairs().forEach(p -> this.visitColumnAgg((Pair)p, specDescription));
    }

    private void visitColumnAgg(Pair pair, String specDescription) {
        this.out.put(pair.output().name(), pair.input().name() + " aggregated with " + specDescription);
    }

    @Override
    public void visit(Count count) {
        this.out.put(count.column().name(), "count");
    }

    @Override
    public void visit(FirstRowKey firstRowKey) {
        this.out.put(firstRowKey.column().name(), "first row key");
    }

    @Override
    public void visit(LastRowKey lastRowKey) {
        this.out.put(lastRowKey.column().name(), "last row key");
    }

    @Override
    public void visit(Partition partition) {
        this.out.put(partition.column().name(), "partition sub-table" + (partition.includeGroupByColumns() ? " (including group-by columns)" : ""));
    }
}

