/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.ImmutableAggregations;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class Aggregations
implements Aggregation {
    public static Builder builder() {
        return ImmutableAggregations.builder();
    }

    public abstract List<Aggregation> aggregations();

    @Override
    public final <V extends Aggregation.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkSize() {
        if (this.aggregations().size() < 2) {
            throw new IllegalArgumentException(String.format("%s should have at least two aggregations", Aggregations.class));
        }
    }

    public static interface Builder {
        public Builder addAggregations(Aggregation var1);

        public Builder addAggregations(Aggregation ... var1);

        public Builder addAllAggregations(Iterable<? extends Aggregation> var1);

        public Aggregations build();
    }
}

