/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.Aggregations;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Aggregations", generator="Immutables")
@Immutable
final class ImmutableAggregations
extends Aggregations {
    private final List<Aggregation> aggregations;

    private ImmutableAggregations(Builder builder) {
        this.aggregations = ImmutableAggregations.createUnmodifiableList(true, builder.aggregations);
    }

    @Override
    public List<Aggregation> aggregations() {
        return this.aggregations;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggregations && this.equalTo((ImmutableAggregations)another);
    }

    private boolean equalTo(ImmutableAggregations another) {
        return this.aggregations.equals(another.aggregations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.aggregations.hashCode();
        return h;
    }

    public String toString() {
        return "Aggregations{aggregations=" + this.aggregations + "}";
    }

    private static ImmutableAggregations validate(ImmutableAggregations instance) {
        instance.checkSize();
        return instance;
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableAggregations.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Aggregations", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements Aggregations.Builder {
        private final List<Aggregation> aggregations = new ArrayList<Aggregation>();

        private Builder() {
        }

        @Override
        public final Builder addAggregations(Aggregation element) {
            this.aggregations.add(Objects.requireNonNull(element, "aggregations element"));
            return this;
        }

        @Override
        public final Builder addAggregations(Aggregation ... elements) {
            for (Aggregation element : elements) {
                this.aggregations.add(Objects.requireNonNull(element, "aggregations element"));
            }
            return this;
        }

        @Override
        public final Builder addAllAggregations(Iterable<? extends Aggregation> elements) {
            for (Aggregation aggregation : elements) {
                this.aggregations.add(Objects.requireNonNull(aggregation, "aggregations element"));
            }
            return this;
        }

        @Override
        public ImmutableAggregations build() {
            return ImmutableAggregations.validate(new ImmutableAggregations(this));
        }
    }
}

