/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Pair;
import io.deephaven.api.agg.spec.AggSpec;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ColumnAggregations", generator="Immutables")
@Immutable
final class ImmutableColumnAggregations
extends ColumnAggregations {
    private final AggSpec spec;
    private final List<Pair> pairs;

    private ImmutableColumnAggregations(Builder builder) {
        this.spec = builder.spec;
        this.pairs = ImmutableColumnAggregations.createUnmodifiableList(true, builder.pairs);
    }

    @Override
    public AggSpec spec() {
        return this.spec;
    }

    @Override
    public List<Pair> pairs() {
        return this.pairs;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumnAggregations && this.equalTo((ImmutableColumnAggregations)another);
    }

    private boolean equalTo(ImmutableColumnAggregations another) {
        return this.spec.equals(another.spec) && this.pairs.equals(another.pairs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.pairs.hashCode();
        return h;
    }

    public String toString() {
        return "ColumnAggregations{spec=" + this.spec + ", pairs=" + this.pairs + "}";
    }

    private static ImmutableColumnAggregations validate(ImmutableColumnAggregations instance) {
        instance.checkSize();
        return instance;
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableColumnAggregations.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ColumnAggregations", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ColumnAggregations.Builder {
        private static final long INIT_BIT_SPEC = 1L;
        private long initBits = 1L;
        @Nullable
        private AggSpec spec;
        private final List<Pair> pairs = new ArrayList<Pair>();

        private Builder() {
        }

        @Override
        public final Builder spec(AggSpec spec) {
            Builder.checkNotIsSet(this.specIsSet(), "spec");
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder addPairs(Pair element) {
            this.pairs.add(Objects.requireNonNull(element, "pairs element"));
            return this;
        }

        @Override
        public final Builder addPairs(Pair ... elements) {
            for (Pair element : elements) {
                this.pairs.add(Objects.requireNonNull(element, "pairs element"));
            }
            return this;
        }

        @Override
        public final Builder addAllPairs(Iterable<? extends Pair> elements) {
            for (Pair pair : elements) {
                this.pairs.add(Objects.requireNonNull(pair, "pairs element"));
            }
            return this;
        }

        @Override
        public ImmutableColumnAggregations build() {
            this.checkRequiredAttributes();
            return ImmutableColumnAggregations.validate(new ImmutableColumnAggregations(this));
        }

        private boolean specIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ColumnAggregations is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.specIsSet()) {
                attributes.add("spec");
            }
            return "Cannot build ColumnAggregations, some of required attributes are not set " + attributes;
        }
    }
}

