/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.Partition;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Partition", generator="Immutables")
@Immutable
final class ImmutablePartition
extends Partition {
    private final ColumnName column;
    private final boolean includeGroupByColumns;

    private ImmutablePartition(ColumnName column) {
        this.column = Objects.requireNonNull(column, "column");
        this.includeGroupByColumns = super.includeGroupByColumns();
    }

    private ImmutablePartition(Builder builder) {
        this.column = builder.column;
        this.includeGroupByColumns = builder.includeGroupByColumnsIsSet() ? builder.includeGroupByColumns : super.includeGroupByColumns();
    }

    @Override
    public ColumnName column() {
        return this.column;
    }

    @Override
    public boolean includeGroupByColumns() {
        return this.includeGroupByColumns;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePartition && this.equalTo((ImmutablePartition)another);
    }

    private boolean equalTo(ImmutablePartition another) {
        return this.column.equals(another.column) && this.includeGroupByColumns == another.includeGroupByColumns;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.column.hashCode();
        h += (h << 5) + Boolean.hashCode(this.includeGroupByColumns);
        return h;
    }

    public String toString() {
        return "Partition{column=" + this.column + ", includeGroupByColumns=" + this.includeGroupByColumns + "}";
    }

    public static ImmutablePartition of(ColumnName column) {
        return new ImmutablePartition(column);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Partition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COLUMN = 1L;
        private static final long OPT_BIT_INCLUDE_GROUP_BY_COLUMNS = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private ColumnName column;
        private boolean includeGroupByColumns;

        private Builder() {
        }

        public final Builder column(ColumnName column) {
            Builder.checkNotIsSet(this.columnIsSet(), "column");
            this.column = Objects.requireNonNull(column, "column");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder includeGroupByColumns(boolean includeGroupByColumns) {
            Builder.checkNotIsSet(this.includeGroupByColumnsIsSet(), "includeGroupByColumns");
            this.includeGroupByColumns = includeGroupByColumns;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePartition build() {
            this.checkRequiredAttributes();
            return new ImmutablePartition(this);
        }

        private boolean includeGroupByColumnsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean columnIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Partition is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.columnIsSet()) {
                attributes.add("column");
            }
            return "Cannot build Partition, some of required attributes are not set " + attributes;
        }
    }
}

