/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.ImmutablePartition;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class Partition
implements Aggregation {
    public static Partition of(ColumnName name) {
        return ImmutablePartition.builder().column(name).build();
    }

    public static Partition of(String x) {
        return Partition.of(ColumnName.of(x));
    }

    public static Partition of(ColumnName name, boolean includeGroupByColumns) {
        return ImmutablePartition.builder().column(name).includeGroupByColumns(includeGroupByColumns).build();
    }

    public static Partition of(String x, boolean includeGroupByColumns) {
        return Partition.of(ColumnName.of(x), includeGroupByColumns);
    }

    @Value.Parameter
    public abstract ColumnName column();

    @Value.Default
    public boolean includeGroupByColumns() {
        return true;
    }

    @Override
    public final <V extends Aggregation.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }
}

