/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.api.ColumnName;
import io.deephaven.api.SortColumn;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.Pair;
import io.deephaven.api.agg.spec.AggSpecAbsSum;
import io.deephaven.api.agg.spec.AggSpecApproximatePercentile;
import io.deephaven.api.agg.spec.AggSpecAvg;
import io.deephaven.api.agg.spec.AggSpecCountDistinct;
import io.deephaven.api.agg.spec.AggSpecDistinct;
import io.deephaven.api.agg.spec.AggSpecFirst;
import io.deephaven.api.agg.spec.AggSpecFormula;
import io.deephaven.api.agg.spec.AggSpecFreeze;
import io.deephaven.api.agg.spec.AggSpecGroup;
import io.deephaven.api.agg.spec.AggSpecLast;
import io.deephaven.api.agg.spec.AggSpecMax;
import io.deephaven.api.agg.spec.AggSpecMedian;
import io.deephaven.api.agg.spec.AggSpecMin;
import io.deephaven.api.agg.spec.AggSpecPercentile;
import io.deephaven.api.agg.spec.AggSpecSortedFirst;
import io.deephaven.api.agg.spec.AggSpecSortedLast;
import io.deephaven.api.agg.spec.AggSpecStd;
import io.deephaven.api.agg.spec.AggSpecSum;
import io.deephaven.api.agg.spec.AggSpecTDigest;
import io.deephaven.api.agg.spec.AggSpecUnique;
import io.deephaven.api.agg.spec.AggSpecVar;
import io.deephaven.api.agg.spec.AggSpecWAvg;
import io.deephaven.api.agg.spec.AggSpecWSum;
import java.util.Arrays;
import java.util.Collection;

public interface AggSpec {
    public static AggSpecAbsSum absSum() {
        return AggSpecAbsSum.of();
    }

    public static AggSpecApproximatePercentile approximatePercentile(double percentile) {
        return AggSpecApproximatePercentile.of(percentile);
    }

    public static AggSpecApproximatePercentile approximatePercentile(double percentile, double compression) {
        return AggSpecApproximatePercentile.of(percentile, compression);
    }

    public static AggSpecAvg avg() {
        return AggSpecAvg.of();
    }

    public static AggSpecCountDistinct countDistinct() {
        return AggSpecCountDistinct.of();
    }

    public static AggSpecCountDistinct countDistinct(boolean countNulls) {
        return AggSpecCountDistinct.of(countNulls);
    }

    public static AggSpecDistinct distinct() {
        return AggSpecDistinct.of();
    }

    public static AggSpecDistinct distinct(boolean includeNulls) {
        return AggSpecDistinct.of(includeNulls);
    }

    public static AggSpecFirst first() {
        return AggSpecFirst.of();
    }

    public static AggSpecFormula formula(String formula) {
        return AggSpecFormula.of(formula);
    }

    public static AggSpecFormula formula(String formula, String paramToken) {
        return AggSpecFormula.of(formula, paramToken);
    }

    public static AggSpecFreeze freeze() {
        return AggSpecFreeze.of();
    }

    public static AggSpecGroup group() {
        return AggSpecGroup.of();
    }

    public static AggSpecLast last() {
        return AggSpecLast.of();
    }

    public static AggSpecMax max() {
        return AggSpecMax.of();
    }

    public static AggSpecMedian median() {
        return AggSpecMedian.of();
    }

    public static AggSpecMedian median(boolean averageEvenlyDivided) {
        return AggSpecMedian.of(averageEvenlyDivided);
    }

    public static AggSpecMin min() {
        return AggSpecMin.of();
    }

    public static AggSpecPercentile percentile(double percentile) {
        return AggSpecPercentile.of(percentile);
    }

    public static AggSpecPercentile percentile(double percentile, boolean averageEvenlyDivided) {
        return AggSpecPercentile.of(percentile, averageEvenlyDivided);
    }

    public static AggSpecSortedFirst sortedFirst(String ... columns) {
        return AggSpec.sortedFirst(Arrays.asList(columns));
    }

    public static AggSpecSortedFirst sortedFirst(Collection<? extends String> columns) {
        AggSpecSortedFirst.Builder builder = AggSpecSortedFirst.builder();
        for (String string : columns) {
            builder.addColumns(SortColumn.asc(ColumnName.of(string)));
        }
        return builder.build();
    }

    public static AggSpecSortedLast sortedLast(String ... columns) {
        return AggSpec.sortedLast(Arrays.asList(columns));
    }

    public static AggSpecSortedLast sortedLast(Collection<? extends String> columns) {
        AggSpecSortedLast.Builder builder = AggSpecSortedLast.builder();
        for (String string : columns) {
            builder.addColumns(SortColumn.asc(ColumnName.of(string)));
        }
        return builder.build();
    }

    public static AggSpecStd std() {
        return AggSpecStd.of();
    }

    public static AggSpecSum sum() {
        return AggSpecSum.of();
    }

    public static AggSpecTDigest tDigest() {
        return AggSpecTDigest.of();
    }

    public static AggSpecTDigest tDigest(double compression) {
        return AggSpecTDigest.of(compression);
    }

    public static AggSpecUnique unique() {
        return AggSpecUnique.of();
    }

    public static AggSpecUnique unique(boolean includeNulls, Object nonUniqueSentinel) {
        return AggSpecUnique.of(includeNulls, nonUniqueSentinel);
    }

    public static AggSpecVar var() {
        return AggSpecVar.of();
    }

    public static AggSpecWAvg wavg(String weightColumn) {
        return AggSpecWAvg.of(ColumnName.of(weightColumn));
    }

    public static AggSpecWSum wsum(String weightColumn) {
        return AggSpecWSum.of(ColumnName.of(weightColumn));
    }

    public ColumnAggregation aggregation(Pair var1);

    public Aggregation aggregation(Pair ... var1);

    public Aggregation aggregation(Collection<? extends Pair> var1);

    public String description();

    public <V extends Visitor> V walk(V var1);

    public static interface Visitor {
        public void visit(AggSpecAbsSum var1);

        public void visit(AggSpecApproximatePercentile var1);

        public void visit(AggSpecAvg var1);

        public void visit(AggSpecCountDistinct var1);

        public void visit(AggSpecDistinct var1);

        public void visit(AggSpecFirst var1);

        public void visit(AggSpecFormula var1);

        public void visit(AggSpecFreeze var1);

        public void visit(AggSpecGroup var1);

        public void visit(AggSpecLast var1);

        public void visit(AggSpecMax var1);

        public void visit(AggSpecMedian var1);

        public void visit(AggSpecMin var1);

        public void visit(AggSpecPercentile var1);

        public void visit(AggSpecSortedFirst var1);

        public void visit(AggSpecSortedLast var1);

        public void visit(AggSpecStd var1);

        public void visit(AggSpecSum var1);

        public void visit(AggSpecTDigest var1);

        public void visit(AggSpecUnique var1);

        public void visit(AggSpecWAvg var1);

        public void visit(AggSpecWSum var1);

        public void visit(AggSpecVar var1);
    }
}

