/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecFormula;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class AggSpecFormula
extends AggSpecBase {
    public static AggSpecFormula of(String formula) {
        return ImmutableAggSpecFormula.builder().formula(formula).build();
    }

    public static AggSpecFormula of(String formula, String paramToken) {
        return ImmutableAggSpecFormula.builder().formula(formula).paramToken(paramToken).build();
    }

    @Override
    public final String description() {
        return "formula '" + this.formula() + "' with column param '" + this.paramToken() + '\'';
    }

    public abstract String formula();

    @Value.Default
    public String paramToken() {
        return "each";
    }

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }
}

