/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.SortColumn;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecSortedFirst;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class AggSpecSortedFirst
extends AggSpecBase {
    public static Builder builder() {
        return ImmutableAggSpecSortedFirst.builder();
    }

    @Override
    public final String description() {
        return "first sorted by " + this.columns().stream().map(sc -> sc.column().name()).collect(Collectors.joining(", "));
    }

    public abstract List<SortColumn> columns();

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void nonEmptyColumns() {
        if (this.columns().isEmpty()) {
            throw new IllegalArgumentException("columns() must be non-empty");
        }
    }

    @Value.Check
    final void checkSortOrder() {
        if (!this.columns().stream().map(SortColumn::order).allMatch(AggSpecSortedFirst::isAscending)) {
            throw new IllegalArgumentException("Can only construct AggSpecSortedFirst with ascending, see https://github.com/deephaven/deephaven-core/issues/821");
        }
    }

    private static boolean isAscending(SortColumn.Order o) {
        return o == SortColumn.Order.ASCENDING;
    }

    public static interface Builder {
        public Builder addColumns(SortColumn var1);

        public Builder addColumns(SortColumn ... var1);

        public Builder addAllColumns(Iterable<? extends SortColumn> var1);

        public AggSpecSortedFirst build();
    }
}

