/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecTDigest;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class AggSpecTDigest
extends AggSpecBase {
    public static AggSpecTDigest of() {
        return ImmutableAggSpecTDigest.builder().build();
    }

    public static AggSpecTDigest of(double compression) {
        return ImmutableAggSpecTDigest.builder().compression(compression).build();
    }

    @Override
    public final String description() {
        return String.format("TDigest with compression %.2f", this.compression());
    }

    @Value.Default
    public double compression() {
        return 100.0;
    }

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkCompression() {
        if (this.compression() < 1.0) {
            throw new IllegalArgumentException("Compression must be greater than or equal to 1.0");
        }
    }
}

