/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.api.SortColumn;
import io.deephaven.api.agg.spec.AggSpecSortedFirst;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AggSpecSortedFirst", generator="Immutables")
@Immutable
final class ImmutableAggSpecSortedFirst
extends AggSpecSortedFirst {
    private final List<SortColumn> columns;

    private ImmutableAggSpecSortedFirst(Builder builder) {
        this.columns = ImmutableAggSpecSortedFirst.createUnmodifiableList(true, builder.columns);
    }

    @Override
    public List<SortColumn> columns() {
        return this.columns;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggSpecSortedFirst && this.equalTo((ImmutableAggSpecSortedFirst)another);
    }

    private boolean equalTo(ImmutableAggSpecSortedFirst another) {
        return this.columns.equals(another.columns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.columns.hashCode();
        return h;
    }

    public String toString() {
        return "AggSpecSortedFirst{columns=" + this.columns + "}";
    }

    private static ImmutableAggSpecSortedFirst validate(ImmutableAggSpecSortedFirst instance) {
        instance.checkSortOrder();
        instance.nonEmptyColumns();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AggSpecSortedFirst", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements AggSpecSortedFirst.Builder {
        private final List<SortColumn> columns = new ArrayList<SortColumn>();

        private Builder() {
        }

        @Override
        public final Builder addColumns(SortColumn element) {
            this.columns.add(Objects.requireNonNull(element, "columns element"));
            return this;
        }

        @Override
        public final Builder addColumns(SortColumn ... elements) {
            for (SortColumn element : elements) {
                this.columns.add(Objects.requireNonNull(element, "columns element"));
            }
            return this;
        }

        @Override
        public final Builder addAllColumns(Iterable<? extends SortColumn> elements) {
            for (SortColumn sortColumn : elements) {
                this.columns.add(Objects.requireNonNull(sortColumn, "columns element"));
            }
            return this;
        }

        @Override
        public ImmutableAggSpecSortedFirst build() {
            return ImmutableAggSpecSortedFirst.validate(new ImmutableAggSpecSortedFirst(this));
        }
    }
}

