/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.util;

import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.util.PercentileOutput;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="PercentileOutput", generator="Immutables")
@Immutable
final class ImmutablePercentileOutput
extends PercentileOutput {
    private final double percentile;
    private final ColumnName output;

    private ImmutablePercentileOutput(double percentile, ColumnName output) {
        this.percentile = percentile;
        this.output = Objects.requireNonNull(output, "output");
    }

    @Override
    public double percentile() {
        return this.percentile;
    }

    @Override
    public ColumnName output() {
        return this.output;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePercentileOutput && this.equalTo((ImmutablePercentileOutput)another);
    }

    private boolean equalTo(ImmutablePercentileOutput another) {
        return Double.doubleToLongBits(this.percentile) == Double.doubleToLongBits(another.percentile) && this.output.equals(another.output);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Double.hashCode(this.percentile);
        h += (h << 5) + this.output.hashCode();
        return h;
    }

    public String toString() {
        return "PercentileOutput{percentile=" + this.percentile + ", output=" + this.output + "}";
    }

    public static ImmutablePercentileOutput of(double percentile, ColumnName output) {
        return ImmutablePercentileOutput.validate(new ImmutablePercentileOutput(percentile, output));
    }

    private static ImmutablePercentileOutput validate(ImmutablePercentileOutput instance) {
        instance.checkPercentile();
        return instance;
    }
}

