/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.api.ColumnName;
import io.deephaven.api.RawString;
import io.deephaven.api.filter.FilterAnd;
import io.deephaven.api.filter.FilterCondition;
import io.deephaven.api.filter.FilterIsNotNull;
import io.deephaven.api.filter.FilterIsNull;
import io.deephaven.api.filter.FilterNot;
import io.deephaven.api.filter.FilterOr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public interface Filter
extends Serializable {
    public static Collection<? extends Filter> from(String ... expressions) {
        return Filter.from(Arrays.asList(expressions));
    }

    public static Collection<? extends Filter> from(Collection<String> expressions) {
        return expressions.stream().map(RawString::of).collect(Collectors.toList());
    }

    public static Collection<? extends Filter> from_(String ... expressions) {
        return Filter.from(expressions);
    }

    public static FilterIsNull isNull(ColumnName column) {
        return FilterIsNull.of(column);
    }

    public static FilterIsNotNull isNotNull(ColumnName column) {
        return FilterIsNotNull.of(column);
    }

    public static FilterNot not(Filter filter) {
        return FilterNot.of(filter);
    }

    public FilterNot not();

    public <V extends Visitor> V walk(V var1);

    public static interface Visitor {
        public void visit(FilterIsNull var1);

        public void visit(FilterIsNotNull var1);

        public void visit(FilterCondition var1);

        public void visit(FilterNot var1);

        public void visit(FilterOr var1);

        public void visit(FilterAnd var1);

        public void visit(RawString var1);
    }
}

