/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterBase;
import io.deephaven.api.filter.ImmutableFilterAnd;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class FilterAnd
extends FilterBase
implements Iterable<Filter> {
    public static Builder builder() {
        return ImmutableFilterAnd.builder();
    }

    public static FilterAnd of(Filter ... filters) {
        return FilterAnd.builder().addFilters(filters).build();
    }

    public static FilterAnd of(Iterable<? extends Filter> filters) {
        return FilterAnd.builder().addAllFilters(filters).build();
    }

    @Value.Parameter
    public abstract List<Filter> filters();

    @Override
    public final <V extends Filter.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Override
    public final Iterator<Filter> iterator() {
        return this.filters().iterator();
    }

    @Override
    public final void forEach(Consumer<? super Filter> action) {
        this.filters().forEach(action);
    }

    @Override
    public final Spliterator<Filter> spliterator() {
        return this.filters().spliterator();
    }

    @Value.Check
    final void checkSize() {
        if (this.filters().size() < 2) {
            throw new IllegalArgumentException(String.format("%s must have at least 2 filters", FilterAnd.class));
        }
    }

    public static interface Builder {
        public Builder addFilters(Filter var1);

        public Builder addFilters(Filter ... var1);

        public Builder addAllFilters(Iterable<? extends Filter> var1);

        public FilterAnd build();
    }
}

