/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterBase;
import io.deephaven.api.filter.ImmutableFilterCondition;
import io.deephaven.api.value.Value;
import java.io.Serializable;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class FilterCondition
extends FilterBase
implements Serializable {
    public static Builder builder() {
        return ImmutableFilterCondition.builder();
    }

    public static FilterCondition lt(Value lhs, Value rhs) {
        return Operator.LESS_THAN.of(lhs, rhs);
    }

    public static FilterCondition lte(Value lhs, Value rhs) {
        return Operator.LESS_THAN_OR_EQUAL.of(lhs, rhs);
    }

    public static FilterCondition gt(Value lhs, Value rhs) {
        return Operator.GREATER_THAN.of(lhs, rhs);
    }

    public static FilterCondition gte(Value lhs, Value rhs) {
        return Operator.GREATER_THAN_OR_EQUAL.of(lhs, rhs);
    }

    public static FilterCondition eq(Value lhs, Value rhs) {
        return Operator.EQUALS.of(lhs, rhs);
    }

    public static FilterCondition neq(Value lhs, Value rhs) {
        return Operator.NOT_EQUALS.of(lhs, rhs);
    }

    public abstract Operator operator();

    public abstract Value lhs();

    public abstract Value rhs();

    public final FilterCondition transpose() {
        return this.operator().transpose().of(this.rhs(), this.lhs());
    }

    public final FilterCondition maybeTranspose() {
        if (this.lhs() instanceof ColumnName) {
            return this;
        }
        if (this.rhs() instanceof ColumnName) {
            return this.transpose();
        }
        return this;
    }

    public final FilterCondition invert() {
        return this.operator().invert().of(this.lhs(), this.rhs());
    }

    @Override
    public final <V extends Filter.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    public static interface Builder {
        public Builder operator(Operator var1);

        public Builder lhs(Value var1);

        public Builder rhs(Value var1);

        public FilterCondition build();
    }

    public static enum Operator {
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        EQUALS,
        NOT_EQUALS;


        public final FilterCondition of(Value lhs, Value rhs) {
            return FilterCondition.builder().operator(this).lhs(lhs).rhs(rhs).build();
        }

        public final Operator invert() {
            switch (this) {
                case LESS_THAN: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN_OR_EQUAL;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN;
                }
                case EQUALS: {
                    return NOT_EQUALS;
                }
                case NOT_EQUALS: {
                    return EQUALS;
                }
            }
            throw new IllegalStateException("Unexpected operator " + (Object)((Object)this));
        }

        public final Operator transpose() {
            switch (this) {
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN_OR_EQUAL;
                }
                case EQUALS: {
                    return EQUALS;
                }
                case NOT_EQUALS: {
                    return NOT_EQUALS;
                }
            }
            throw new IllegalStateException("Unexpected operator " + (Object)((Object)this));
        }
    }
}

