/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterAnd;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FilterAnd", generator="Immutables")
@Immutable
final class ImmutableFilterAnd
extends FilterAnd {
    private final List<Filter> filters;

    private ImmutableFilterAnd(Iterable<? extends Filter> filters) {
        this.filters = ImmutableFilterAnd.createUnmodifiableList(false, ImmutableFilterAnd.createSafeList(filters, true, false));
    }

    private ImmutableFilterAnd(Builder builder) {
        this.filters = ImmutableFilterAnd.createUnmodifiableList(true, builder.filters);
    }

    @Override
    public List<Filter> filters() {
        return this.filters;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFilterAnd && this.equalTo((ImmutableFilterAnd)another);
    }

    private boolean equalTo(ImmutableFilterAnd another) {
        return this.filters.equals(another.filters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.filters.hashCode();
        return h;
    }

    public String toString() {
        return "FilterAnd{filters=" + this.filters + "}";
    }

    public static ImmutableFilterAnd of(List<Filter> filters) {
        return ImmutableFilterAnd.of(filters);
    }

    public static ImmutableFilterAnd of(Iterable<? extends Filter> filters) {
        return ImmutableFilterAnd.validate(new ImmutableFilterAnd(filters));
    }

    private static ImmutableFilterAnd validate(ImmutableFilterAnd instance) {
        instance.checkSize();
        return instance;
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableFilterAnd.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FilterAnd", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements FilterAnd.Builder {
        private final List<Filter> filters = new ArrayList<Filter>();

        private Builder() {
        }

        @Override
        public final Builder addFilters(Filter element) {
            this.filters.add(Objects.requireNonNull(element, "filters element"));
            return this;
        }

        @Override
        public final Builder addFilters(Filter ... elements) {
            for (Filter element : elements) {
                this.filters.add(Objects.requireNonNull(element, "filters element"));
            }
            return this;
        }

        @Override
        public final Builder addAllFilters(Iterable<? extends Filter> elements) {
            for (Filter filter : elements) {
                this.filters.add(Objects.requireNonNull(filter, "filters element"));
            }
            return this;
        }

        @Override
        public ImmutableFilterAnd build() {
            return ImmutableFilterAnd.validate(new ImmutableFilterAnd(this));
        }
    }
}

