/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;

public class NameValidator {
    private static final String COLUMN_PREFIX = "column_";
    private static final String QUERY_PREFIX = "var_";
    private static final String TABLE_PREFIX = "table_";
    private static final String STERILE_COLUMN_AND_QUERY_REGEX = "[^A-Za-z0-9_$]";
    private static final String STERILE_TABLE_AND_NAMESPACE_REGEX = "[^a-zA-Z0-9_$\\-\\+@]";
    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("([a-zA-Z_$])[a-zA-Z0-9_$[-][+]@]*");
    private static final Pattern PARTITION_NAME_PATTERN = Pattern.compile("([a-zA-Z0-9$])[a-zA-Z0-9_$[-][+]@\\.]*");
    private static final Set<String> QUERY_LANG_RESERVED_VARIABLE_NAMES = Stream.of("in", "not", "i", "ii", "k").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));

    public static String validateTableName(String name) {
        return Type.TABLE.validate(name);
    }

    public static String validateNamespaceName(String name) {
        return Type.NAMESPACE.validate(name);
    }

    public static String validatePartitionName(String name) {
        return Type.PARTITION.validate(name);
    }

    public static String validateQueryParameterName(String name) {
        return Type.QUERY_PARAM.validate(name);
    }

    public static String validateColumnName(String name) {
        return Type.COLUMN.validate(name);
    }

    public static boolean isValidColumnName(String name) {
        try {
            NameValidator.validateColumnName(name);
            return true;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    private static ValidationCode getCode(String name, Pattern pattern, boolean checkReservedVariableNames, boolean checkValidJavaWord) {
        if (name == null || name.isEmpty()) {
            return ValidationCode.NULL_NAME;
        }
        if (checkReservedVariableNames && NameValidator.isReserved(name)) {
            return ValidationCode.RESERVED;
        }
        if (checkValidJavaWord && !SourceVersion.isIdentifier(name)) {
            return ValidationCode.INVALID;
        }
        if (pattern == null) {
            return ValidationCode.OK;
        }
        if (pattern.matcher(name).matches()) {
            return ValidationCode.OK;
        }
        return ValidationCode.INVALID;
    }

    public static String legalizeColumnName(String name) {
        return NameValidator.legalizeColumnName(name, Collections.emptySet());
    }

    public static String legalizeColumnName(String name, Set<String> takenNames) {
        return NameValidator.legalizeColumnName(name, Function.identity(), takenNames);
    }

    public static String legalizeColumnName(String name, Function<String, String> replaceCustom) {
        return NameValidator.legalizeColumnName(name, replaceCustom, Collections.emptySet());
    }

    public static String legalizeColumnName(String name, Function<String, String> customReplace, Set<String> takenNames) {
        return NameValidator.legalizeName(name, customReplace, takenNames, "Can not legalize column name " + name, COLUMN_PREFIX, STERILE_COLUMN_AND_QUERY_REGEX, true, true, NameValidator::validateColumnName);
    }

    public static String[] legalizeColumnNames(String[] names) {
        return NameValidator.legalizeColumnNames(names, Function.identity());
    }

    public static String[] legalizeColumnNames(String[] names, Function<String, String> customReplace) {
        return NameValidator.legalizeColumnNames(names, customReplace, false);
    }

    public static String[] legalizeColumnNames(String[] names, boolean resolveConflicts) {
        return NameValidator.legalizeColumnNames(names, Function.identity(), resolveConflicts);
    }

    public static String[] legalizeColumnNames(String[] names, Function<String, String> customReplace, boolean resolveConflicts) {
        return NameValidator.legalizeNames(names, customReplace, resolveConflicts, NameValidator::legalizeColumnName);
    }

    public static String legalizeQueryParameterName(String name) {
        return NameValidator.legalizeQueryParameterName(name, Function.identity());
    }

    public static String legalizeQueryParameterName(String name, Function<String, String> replaceCustom) {
        return NameValidator.legalizeQueryParameterName(name, replaceCustom, Collections.emptySet());
    }

    public static String legalizeQueryParameterName(String name, Set<String> takenNames) {
        return NameValidator.legalizeQueryParameterName(name, Function.identity(), takenNames);
    }

    public static String legalizeQueryParameterName(String name, Function<String, String> customReplace, Set<String> takenNames) {
        return NameValidator.legalizeName(name, customReplace, takenNames, "Can not legalize table name " + name, QUERY_PREFIX, STERILE_COLUMN_AND_QUERY_REGEX, true, true, NameValidator::validateQueryParameterName);
    }

    public static String[] legalizeQueryParameterNames(String[] names) {
        return NameValidator.legalizeQueryParameterNames(names, Function.identity());
    }

    public static String[] legalizeQueryParameterNames(String[] names, Function<String, String> customReplace) {
        return NameValidator.legalizeQueryParameterNames(names, customReplace, false);
    }

    public static String[] legalizeQueryParameterNames(String[] names, boolean resolveConflicts) {
        return NameValidator.legalizeQueryParameterNames(names, Function.identity(), resolveConflicts);
    }

    public static String[] legalizeQueryParameterNames(String[] names, Function<String, String> customReplace, boolean resolveConflicts) {
        return NameValidator.legalizeNames(names, customReplace, resolveConflicts, NameValidator::legalizeQueryParameterName);
    }

    public static String legalizeTableName(String name) {
        return NameValidator.legalizeTableName(name, Collections.emptySet());
    }

    public static String legalizeTableName(String name, Set<String> takenNames) {
        return NameValidator.legalizeTableName(name, Function.identity(), takenNames);
    }

    public static String legalizeTableName(String name, Function<String, String> replaceCustom) {
        return NameValidator.legalizeTableName(name, replaceCustom, Collections.emptySet());
    }

    public static String legalizeTableName(String name, Function<String, String> customReplace, Set<String> takenNames) {
        return NameValidator.legalizeName(name, customReplace, takenNames, "Can not legalize table name " + name, TABLE_PREFIX, STERILE_TABLE_AND_NAMESPACE_REGEX, false, true, NameValidator::validateTableName);
    }

    public static boolean isLegalTableName(String name) {
        return NameValidator.isLegalTableName(name, Collections.emptySet());
    }

    public static boolean isLegalTableName(String name, Set<String> takenNames) {
        return NameValidator.isLegalTableName(name, Function.identity(), takenNames);
    }

    public static boolean isLegalTableName(String name, Function<String, String> replaceCustom) {
        return NameValidator.isLegalTableName(name, replaceCustom, Collections.emptySet());
    }

    public static boolean isLegalTableName(String name, Function<String, String> customReplace, Set<String> takenNames) {
        return NameValidator.isLegal(name, customReplace, takenNames, STERILE_TABLE_AND_NAMESPACE_REGEX, false, true, NameValidator::validateTableName);
    }

    public static String[] legalizeTableNames(String[] names) {
        return NameValidator.legalizeTableNames(names, Function.identity());
    }

    public static String[] legalizeTableNames(String[] names, Function<String, String> customReplace) {
        return NameValidator.legalizeTableNames(names, customReplace, false);
    }

    public static String[] legalizeTableNames(String[] names, boolean resolveConflicts) {
        return NameValidator.legalizeTableNames(names, Function.identity(), resolveConflicts);
    }

    public static String[] legalizeTableNames(String[] names, Function<String, String> customReplace, boolean resolveConflicts) {
        return NameValidator.legalizeNames(names, customReplace, resolveConflicts, NameValidator::legalizeTableName);
    }

    public static String legalizeNamespaceName(String name) {
        return NameValidator.legalizeNamespaceName(name, Collections.emptySet());
    }

    public static String legalizeNamespaceName(String name, Set<String> takenNames) {
        return NameValidator.legalizeNamespaceName(name, Function.identity(), takenNames);
    }

    public static String legalizeNamespaceName(String name, Function<String, String> replaceCustom) {
        return NameValidator.legalizeNamespaceName(name, replaceCustom, Collections.emptySet());
    }

    public static String legalizeNamespaceName(String name, Function<String, String> customReplace, Set<String> takenNames) {
        return NameValidator.legalizeName(name, customReplace, takenNames, "Can not legalize namespace name " + name, null, STERILE_TABLE_AND_NAMESPACE_REGEX, false, false, NameValidator::validateNamespaceName);
    }

    public static boolean isLegalNamespaceName(String name, Function<String, String> customReplace, Set<String> takenNames) {
        return NameValidator.isLegal(name, customReplace, takenNames, STERILE_TABLE_AND_NAMESPACE_REGEX, false, false, NameValidator::validateNamespaceName);
    }

    public static boolean isLegalNamespaceName(String name) {
        return NameValidator.isLegalNamespaceName(name, Collections.emptySet());
    }

    public static boolean isLegalNamespaceName(String name, Set<String> takenNames) {
        return NameValidator.isLegalNamespaceName(name, Function.identity(), takenNames);
    }

    public static boolean isLegalNamespaceName(String name, Function<String, String> replaceCustom) {
        return NameValidator.isLegalNamespaceName(name, replaceCustom, Collections.emptySet());
    }

    public static String[] legalizeNamespaceNames(String[] names) {
        return NameValidator.legalizeNamespaceNames(names, Function.identity());
    }

    public static String[] legalizeNamespaceNames(String[] names, Function<String, String> customReplace) {
        return NameValidator.legalizeNamespaceNames(names, customReplace, false);
    }

    public static String[] legalizeNamespaceNames(String[] names, boolean resolveConflicts) {
        return NameValidator.legalizeNamespaceNames(names, Function.identity(), resolveConflicts);
    }

    public static String[] legalizeNamespaceNames(String[] names, Function<String, String> customReplace, boolean resolveConflicts) {
        return NameValidator.legalizeNames(names, customReplace, resolveConflicts, NameValidator::legalizeNamespaceName);
    }

    private static String legalizeName(String name, Function<String, String> customReplace, Set<String> takenNames, String error, String prefix, String regex, boolean checkReserved, boolean checkFirstIsNumber, Consumer<String> validation) {
        String sanitizedName;
        if (name == null) {
            throw new LegalizeNameException("Can not legalize a null name");
        }
        Objects.requireNonNull(customReplace, "customReplace");
        Objects.requireNonNull(takenNames, "takenNames");
        String replacedName = customReplace.apply(name);
        if (checkReserved && NameValidator.isReserved(replacedName)) {
            replacedName = prefix + replacedName;
        }
        if ((sanitizedName = replacedName.replaceAll(regex, "")).isEmpty()) {
            throw new LegalizeNameException(error);
        }
        if (Character.isDigit(sanitizedName.charAt(0)) && checkFirstIsNumber) {
            sanitizedName = prefix + sanitizedName;
        }
        int i = 2;
        String tempName = sanitizedName;
        while (takenNames.contains(tempName)) {
            tempName = sanitizedName + i++;
        }
        try {
            validation.accept(sanitizedName);
        }
        catch (InvalidNameException e) {
            throw new LegalizeNameException(error);
        }
        return tempName;
    }

    private static boolean isLegal(String name, Function<String, String> customReplace, Set<String> takenNames, String regex, boolean checkReserved, boolean checkFirstIsNumber, Consumer<String> validation) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(customReplace, "customReplace");
        Objects.requireNonNull(takenNames, "takenNames");
        String replacedName = customReplace.apply(name);
        if (checkReserved && NameValidator.isReserved(replacedName)) {
            return false;
        }
        String sanitizedName = replacedName.replaceAll(regex, "");
        if (!Objects.equals(sanitizedName, replacedName)) {
            return false;
        }
        if (checkFirstIsNumber && Character.isDigit(sanitizedName.charAt(0))) {
            return false;
        }
        if (takenNames.contains(replacedName)) {
            return false;
        }
        try {
            validation.accept(sanitizedName);
        }
        catch (InvalidNameException e) {
            return false;
        }
        return true;
    }

    private static boolean isReserved(String replacedName) {
        return QUERY_LANG_RESERVED_VARIABLE_NAMES.contains(replacedName) || SourceVersion.isKeyword(replacedName);
    }

    private static String[] legalizeNames(String[] names, Function<String, String> customReplace, boolean resolveConflicts, Legalizer legalizer) {
        if (names == null) {
            throw new LegalizeNameException("Can not legalize a null name array");
        }
        Objects.requireNonNull(customReplace, "customReplace");
        Objects.requireNonNull(legalizer, "legalizer");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String name : names) {
            name = legalizer.apply(name, customReplace, resolveConflicts ? result : Collections.emptySet());
            if (!resolveConflicts && result.contains(name)) {
                throw new LegalizeNameException("Duplicate names during legalization: " + name);
            }
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    static /* synthetic */ Pattern access$000() {
        return TABLE_NAME_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return PARTITION_NAME_PATTERN;
    }

    @FunctionalInterface
    private static interface Legalizer {
        public String apply(String var1, Function<String, String> var2, Set<String> var3);
    }

    public static class LegalizeNameException
    extends IllegalArgumentException {
        LegalizeNameException(String message) {
            super(message);
        }
    }

    public static class InvalidNameException
    extends IllegalArgumentException {
        InvalidNameException(String message) {
            super(message);
        }
    }

    public static enum Type {
        COLUMN(true, true, "column", null),
        QUERY_PARAM(true, true, "query variable", null),
        TABLE(false, false, "table", NameValidator.access$000()),
        NAMESPACE(false, false, "namespace", NameValidator.access$000()),
        PARTITION(false, false, "partition", NameValidator.access$100());

        private final boolean checkReservedVariableNames;
        private final boolean checkValidJavaWord;
        private final String type;
        private final Pattern pattern;

        public String toString() {
            return this.type;
        }

        private Type(boolean checkReservedVariableNames, boolean checkValidJavaWord, String type, Pattern pattern) {
            this.checkReservedVariableNames = checkReservedVariableNames;
            this.checkValidJavaWord = checkValidJavaWord;
            this.type = type;
            this.pattern = pattern;
        }

        private String validate(String name) {
            ValidationCode code = NameValidator.getCode(name, this.pattern, this.checkReservedVariableNames, this.checkValidJavaWord);
            if (!code.isValid()) {
                throw new InvalidNameException(code.getErrorMessage(name, this.type));
            }
            return name;
        }
    }

    private static enum ValidationCode {
        OK(""),
        RESERVED("Invalid <type> name \"<name>\": \"<name>\" is a reserved keyword"),
        INVALID("Invalid <type> name \"<name>\""),
        NULL_NAME("Invalid <type> name: name can not be null or empty");

        private final String message;

        private ValidationCode(String message) {
            this.message = message;
        }

        private String getErrorMessage(String name, String type) {
            return this.message.replace("<name>", name == null ? "null" : name).replaceAll("<type>", type);
        }

        private boolean isValid() {
            return this == OK;
        }
    }
}

