/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import io.deephaven.plugins.monitoring.Interval;

public enum Formula {
    SUM{

        @Override
        public double compute(Interval interval, long n, long sum) {
            return sum;
        }
    }
    ,
    AVG{

        @Override
        public double compute(Interval interval, long n, long sum) {
            return (double)sum / (double)n;
        }
    }
    ,
    AVG_MULT_1Ki{

        @Override
        public double compute(Interval interval, long n, long sum) {
            return AVG.compute(interval, n, sum) * 1024.0;
        }
    }
    ,
    SUM_PER_MINUTE{

        @Override
        public double compute(Interval interval, long n, long sum) {
            double minutes = (double)interval.millis() / 60000.0;
            return (double)sum / minutes;
        }
    }
    ,
    SUM_PER_INTERVAL{

        @Override
        public double compute(Interval interval, long n, long sum) {
            return (double)sum / (double)interval.millis();
        }
    }
    ,
    JIFFIES_TO_CPU_PERC{

        @Override
        public double compute(Interval interval, long n, long sum) {
            int HZ = 100;
            int percent = 100;
            return (double)sum / 100.0 / (double)interval.getNumberOf10s() / 100.0;
        }
    };


    public abstract double compute(Interval var1, long var2, long var4);
}

