/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import io.deephaven.plugins.monitoring.Formula;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.Unit;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GCMetrics {
    public static List<Metric> all() {
        return GCMetrics.descriptors().collect(Collectors.toList());
    }

    public static Stream<Metric> descriptors() {
        return Stream.of(GCMetrics.parnewTime(), GCMetrics.cmsTime(), GCMetrics.cmsCount(), GCMetrics.parnewCount(), GCMetrics.reclaimed());
    }

    public static Metric cmsTime() {
        return GCMetrics.gcTime("ConcurrentMarkSweep", "cms-time");
    }

    public static Metric parnewTime() {
        return GCMetrics.gcTime("ParNew", "parnew-time");
    }

    public static Metric cmsCount() {
        return GCMetrics.gcCount("ConcurrentMarkSweep", "cms-count");
    }

    public static Metric parnewCount() {
        return GCMetrics.gcCount("ParNew", "parnew-count");
    }

    private static Metric gcCount(String type, String rename) {
        return Metric.builder().name(String.format("Memory-GC.%s-Count", type)).rename(rename).unit(Unit.COUNT_PER_MIN).formula(Formula.SUM_PER_MINUTE).build();
    }

    private static Metric gcTime(String type, String rename) {
        return Metric.builder().name(String.format("Memory-GC.%s-Time", type)).rename(rename).unit(Unit.TIME_PERCENT).formula(Formula.SUM_PER_INTERVAL).build();
    }

    public static Metric reclaimed() {
        return Metric.builder().name("Memory-GC.Reclaimed").rename("memory-reclaimed").unit(Unit.BYTES_PER_MIN).formula(Formula.SUM_PER_MINUTE).build();
    }
}

