/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.plugins.monitoring.Formula;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.Unit;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Metric", generator="Immutables")
@Immutable
public final class ImmutableMetric
extends Metric {
    private final String name;
    private final String rename;
    private final Unit unit;
    private final Formula formula;

    private ImmutableMetric(Builder builder) {
        this.name = builder.name;
        this.rename = builder.rename;
        this.unit = builder.unit;
        this.formula = builder.formula;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String rename() {
        return this.rename;
    }

    @Override
    public Unit unit() {
        return this.unit;
    }

    @Override
    public Formula formula() {
        return this.formula;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetric && this.equalTo((ImmutableMetric)another);
    }

    private boolean equalTo(ImmutableMetric another) {
        return this.name.equals(another.name) && this.rename.equals(another.rename) && this.unit.equals((Object)another.unit) && this.formula.equals((Object)another.formula);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.rename.hashCode();
        h += (h << 5) + this.unit.hashCode();
        h += (h << 5) + this.formula.hashCode();
        return h;
    }

    public String toString() {
        return "Metric{name=" + this.name + ", rename=" + this.rename + ", unit=" + (Object)((Object)this.unit) + ", formula=" + (Object)((Object)this.formula) + "}";
    }

    @Generated(from="Metric", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RENAME = 2L;
        private static final long INIT_BIT_UNIT = 4L;
        private static final long INIT_BIT_FORMULA = 8L;
        private long initBits = 15L;
        @Nullable
        private String name;
        @Nullable
        private String rename;
        @Nullable
        private Unit unit;
        @Nullable
        private Formula formula;

        public Builder() {
            if (!(this instanceof Metric.Builder)) {
                throw new UnsupportedOperationException("Use: new Metric.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final Metric.Builder from(Metric instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.rename(instance.rename());
            this.unit(instance.unit());
            this.formula(instance.formula());
            return (Metric.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Metric.Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Metric.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Metric.Builder rename(String rename) {
            this.rename = Objects.requireNonNull(rename, "rename");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Metric.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Metric.Builder unit(Unit unit) {
            this.unit = Objects.requireNonNull(unit, "unit");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (Metric.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Metric.Builder formula(Formula formula) {
            this.formula = Objects.requireNonNull(formula, "formula");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (Metric.Builder)this;
        }

        public Metric build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMetric(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rename");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("unit");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("formula");
            }
            return "Cannot build Metric, some of required attributes are not set " + attributes;
        }
    }
}

