/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.Metric;
import io.deephaven.plugins.monitoring.MetricInterval;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetricInterval", generator="Immutables")
@Immutable
public final class ImmutableMetricInterval
extends MetricInterval {
    private final Metric metric;
    private final Interval interval;

    private ImmutableMetricInterval(Builder builder) {
        this.metric = builder.metric;
        this.interval = builder.interval;
    }

    @Override
    public Metric metric() {
        return this.metric;
    }

    @Override
    public Interval interval() {
        return this.interval;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetricInterval && this.equalTo((ImmutableMetricInterval)another);
    }

    private boolean equalTo(ImmutableMetricInterval another) {
        return this.metric.equals(another.metric) && this.interval.equals((Object)another.interval);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.metric.hashCode();
        h += (h << 5) + this.interval.hashCode();
        return h;
    }

    public String toString() {
        return "MetricInterval{metric=" + this.metric + ", interval=" + (Object)((Object)this.interval) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetricInterval", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METRIC = 1L;
        private static final long INIT_BIT_INTERVAL = 2L;
        private long initBits = 3L;
        @Nullable
        private Metric metric;
        @Nullable
        private Interval interval;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetricInterval instance) {
            Objects.requireNonNull(instance, "instance");
            this.metric(instance.metric());
            this.interval(instance.interval());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metric(Metric metric) {
            this.metric = Objects.requireNonNull(metric, "metric");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder interval(Interval interval) {
            this.interval = Objects.requireNonNull(interval, "interval");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public MetricInterval build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMetricInterval(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metric");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("interval");
            }
            return "Cannot build MetricInterval, some of required attributes are not set " + attributes;
        }
    }
}

