/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.plugins.monitoring.MetricInterval;
import io.deephaven.plugins.monitoring.MetricIntervals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetricIntervals", generator="Immutables")
@Immutable
public final class ImmutableMetricIntervals
extends MetricIntervals {
    private final Set<MetricInterval> metrics;

    private ImmutableMetricIntervals(Builder builder) {
        this.metrics = ImmutableMetricIntervals.createUnmodifiableSet(builder.metrics);
    }

    @Override
    public Set<MetricInterval> metrics() {
        return this.metrics;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetricIntervals && this.equalTo((ImmutableMetricIntervals)another);
    }

    private boolean equalTo(ImmutableMetricIntervals another) {
        return this.metrics.equals(another.metrics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.metrics.hashCode();
        return h;
    }

    public String toString() {
        return "MetricIntervals{metrics=" + this.metrics + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="MetricIntervals", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<MetricInterval> metrics = new ArrayList<MetricInterval>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetricIntervals instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMetrics(instance.metrics());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMetrics(MetricInterval element) {
            this.metrics.add(Objects.requireNonNull(element, "metrics element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMetrics(MetricInterval ... elements) {
            for (MetricInterval element : elements) {
                this.metrics.add(Objects.requireNonNull(element, "metrics element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metrics(Iterable<? extends MetricInterval> elements) {
            this.metrics.clear();
            return this.addAllMetrics(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMetrics(Iterable<? extends MetricInterval> elements) {
            for (MetricInterval metricInterval : elements) {
                this.metrics.add(Objects.requireNonNull(metricInterval, "metrics element"));
            }
            return this;
        }

        public MetricIntervals build() {
            return new ImmutableMetricIntervals(this);
        }
    }
}

