/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.MetricIntervals;
import io.deephaven.plugins.monitoring.ProcessDashboard;
import io.deephaven.plugins.monitoring.ProcessInfoKeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProcessDashboard", generator="Immutables")
@Immutable
public final class ImmutableProcessDashboard
extends ProcessDashboard {
    private final Database db;
    private final boolean includeMetricsTimestamp;
    private final List<ProcessInfoKeyDescriptor> keys;
    private final MetricIntervals metrics;
    private final int numDaysDecoration;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableProcessDashboard(Builder builder) {
        this.db = builder.db;
        if (builder.includeMetricsTimestampIsSet()) {
            this.initShim.includeMetricsTimestamp(builder.includeMetricsTimestamp);
        }
        if (builder.keysIsSet()) {
            this.initShim.keys(ImmutableProcessDashboard.createUnmodifiableList(true, builder.keys));
        }
        if (builder.metrics != null) {
            this.initShim.metrics(builder.metrics);
        }
        if (builder.numDaysDecorationIsSet()) {
            this.initShim.numDaysDecoration(builder.numDaysDecoration);
        }
        this.includeMetricsTimestamp = this.initShim.includeMetricsTimestamp();
        this.keys = this.initShim.keys();
        this.metrics = this.initShim.metrics();
        this.numDaysDecoration = this.initShim.numDaysDecoration();
        this.initShim = null;
    }

    @Override
    public Database db() {
        return this.db;
    }

    @Override
    public boolean includeMetricsTimestamp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.includeMetricsTimestamp() : this.includeMetricsTimestamp;
    }

    @Override
    public List<ProcessInfoKeyDescriptor> keys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keys() : this.keys;
    }

    @Override
    public MetricIntervals metrics() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metrics() : this.metrics;
    }

    @Override
    public int numDaysDecoration() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numDaysDecoration() : this.numDaysDecoration;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessDashboard && this.equalTo((ImmutableProcessDashboard)another);
    }

    private boolean equalTo(ImmutableProcessDashboard another) {
        return this.db.equals(another.db) && this.includeMetricsTimestamp == another.includeMetricsTimestamp && this.keys.equals(another.keys) && this.metrics.equals(another.metrics) && this.numDaysDecoration == another.numDaysDecoration;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + Boolean.hashCode(this.includeMetricsTimestamp);
        h += (h << 5) + this.keys.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        h += (h << 5) + this.numDaysDecoration;
        return h;
    }

    public String toString() {
        return "ProcessDashboard{db=" + this.db + ", includeMetricsTimestamp=" + this.includeMetricsTimestamp + ", keys=" + this.keys + ", metrics=" + this.metrics + ", numDaysDecoration=" + this.numDaysDecoration + "}";
    }

    private static ImmutableProcessDashboard validate(ImmutableProcessDashboard instance) {
        instance.checkNumDaysDecoration();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ProcessDashboard", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long OPT_BIT_INCLUDE_METRICS_TIMESTAMP = 1L;
        private static final long OPT_BIT_KEYS = 2L;
        private static final long OPT_BIT_NUM_DAYS_DECORATION = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Database db;
        private boolean includeMetricsTimestamp;
        private List<ProcessInfoKeyDescriptor> keys = new ArrayList<ProcessInfoKeyDescriptor>();
        @Nullable
        private MetricIntervals metrics;
        private int numDaysDecoration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProcessDashboard instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.db());
            this.includeMetricsTimestamp(instance.includeMetricsTimestamp());
            this.addAllKeys(instance.keys());
            this.metrics(instance.metrics());
            this.numDaysDecoration(instance.numDaysDecoration());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(Database db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder includeMetricsTimestamp(boolean includeMetricsTimestamp) {
            this.includeMetricsTimestamp = includeMetricsTimestamp;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeys(ProcessInfoKeyDescriptor element) {
            this.keys.add(Objects.requireNonNull(element, "keys element"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeys(ProcessInfoKeyDescriptor ... elements) {
            for (ProcessInfoKeyDescriptor element : elements) {
                this.keys.add(Objects.requireNonNull(element, "keys element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keys(Iterable<? extends ProcessInfoKeyDescriptor> elements) {
            this.keys.clear();
            return this.addAllKeys(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeys(Iterable<? extends ProcessInfoKeyDescriptor> elements) {
            for (ProcessInfoKeyDescriptor processInfoKeyDescriptor : elements) {
                this.keys.add(Objects.requireNonNull(processInfoKeyDescriptor, "keys element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metrics(MetricIntervals metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numDaysDecoration(int numDaysDecoration) {
            this.numDaysDecoration = numDaysDecoration;
            this.optBits |= 4L;
            return this;
        }

        public ProcessDashboard build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableProcessDashboard.validate(new ImmutableProcessDashboard(this));
        }

        private boolean includeMetricsTimestampIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean keysIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean numDaysDecorationIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            return "Cannot build ProcessDashboard, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ProcessDashboard", generator="Immutables")
    private final class InitShim {
        private byte includeMetricsTimestampBuildStage = 0;
        private boolean includeMetricsTimestamp;
        private byte keysBuildStage = 0;
        private List<ProcessInfoKeyDescriptor> keys;
        private byte metricsBuildStage = 0;
        private MetricIntervals metrics;
        private byte numDaysDecorationBuildStage = 0;
        private int numDaysDecoration;

        private InitShim() {
        }

        boolean includeMetricsTimestamp() {
            if (this.includeMetricsTimestampBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.includeMetricsTimestampBuildStage == 0) {
                this.includeMetricsTimestampBuildStage = (byte)-1;
                this.includeMetricsTimestamp = ImmutableProcessDashboard.super.includeMetricsTimestamp();
                this.includeMetricsTimestampBuildStage = 1;
            }
            return this.includeMetricsTimestamp;
        }

        void includeMetricsTimestamp(boolean includeMetricsTimestamp) {
            this.includeMetricsTimestamp = includeMetricsTimestamp;
            this.includeMetricsTimestampBuildStage = 1;
        }

        List<ProcessInfoKeyDescriptor> keys() {
            if (this.keysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keysBuildStage == 0) {
                this.keysBuildStage = (byte)-1;
                this.keys = ImmutableProcessDashboard.createUnmodifiableList(false, ImmutableProcessDashboard.createSafeList(ImmutableProcessDashboard.super.keys(), true, false));
                this.keysBuildStage = 1;
            }
            return this.keys;
        }

        void keys(List<ProcessInfoKeyDescriptor> keys) {
            this.keys = keys;
            this.keysBuildStage = 1;
        }

        MetricIntervals metrics() {
            if (this.metricsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metricsBuildStage == 0) {
                this.metricsBuildStage = (byte)-1;
                this.metrics = Objects.requireNonNull(ImmutableProcessDashboard.super.metrics(), "metrics");
                this.metricsBuildStage = 1;
            }
            return this.metrics;
        }

        void metrics(MetricIntervals metrics) {
            this.metrics = metrics;
            this.metricsBuildStage = 1;
        }

        int numDaysDecoration() {
            if (this.numDaysDecorationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numDaysDecorationBuildStage == 0) {
                this.numDaysDecorationBuildStage = (byte)-1;
                this.numDaysDecoration = ImmutableProcessDashboard.super.numDaysDecoration();
                this.numDaysDecorationBuildStage = 1;
            }
            return this.numDaysDecoration;
        }

        void numDaysDecoration(int numDaysDecoration) {
            this.numDaysDecoration = numDaysDecoration;
            this.numDaysDecorationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.includeMetricsTimestampBuildStage == -1) {
                attributes.add("includeMetricsTimestamp");
            }
            if (this.keysBuildStage == -1) {
                attributes.add("keys");
            }
            if (this.metricsBuildStage == -1) {
                attributes.add("metrics");
            }
            if (this.numDaysDecorationBuildStage == -1) {
                attributes.add("numDaysDecoration");
            }
            return "Cannot build ProcessDashboard, attribute initializers form cycle " + attributes;
        }
    }
}

