/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.ProcessIdInternalDecorationQuery;
import io.deephaven.plugins.monitoring.ProcessInfoKeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProcessIdInternalDecorationQuery", generator="Immutables")
@Immutable
public final class ImmutableProcessIdInternalDecorationQuery
extends ProcessIdInternalDecorationQuery {
    private final Database db;
    private final List<ProcessInfoKeyDescriptor> keys;
    private final int numDays;

    private ImmutableProcessIdInternalDecorationQuery(Builder builder) {
        this.db = builder.db;
        this.keys = ImmutableProcessIdInternalDecorationQuery.createUnmodifiableList(true, builder.keys);
        this.numDays = builder.numDays;
    }

    @Override
    public Database db() {
        return this.db;
    }

    @Override
    public List<ProcessInfoKeyDescriptor> keys() {
        return this.keys;
    }

    @Override
    public int numDays() {
        return this.numDays;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessIdInternalDecorationQuery && this.equalTo((ImmutableProcessIdInternalDecorationQuery)another);
    }

    private boolean equalTo(ImmutableProcessIdInternalDecorationQuery another) {
        return this.db.equals(another.db) && this.keys.equals(another.keys) && this.numDays == another.numDays;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.keys.hashCode();
        h += (h << 5) + this.numDays;
        return h;
    }

    public String toString() {
        return "ProcessIdInternalDecorationQuery{db=" + this.db + ", keys=" + this.keys + ", numDays=" + this.numDays + "}";
    }

    private static ImmutableProcessIdInternalDecorationQuery validate(ImmutableProcessIdInternalDecorationQuery instance) {
        instance.checkDays();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ProcessIdInternalDecorationQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_NUM_DAYS = 2L;
        private long initBits = 3L;
        @Nullable
        private Database db;
        private List<ProcessInfoKeyDescriptor> keys = new ArrayList<ProcessInfoKeyDescriptor>();
        private int numDays;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProcessIdInternalDecorationQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.db());
            this.addAllKeys(instance.keys());
            this.numDays(instance.numDays());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(Database db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeys(ProcessInfoKeyDescriptor element) {
            this.keys.add(Objects.requireNonNull(element, "keys element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeys(ProcessInfoKeyDescriptor ... elements) {
            for (ProcessInfoKeyDescriptor element : elements) {
                this.keys.add(Objects.requireNonNull(element, "keys element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keys(Iterable<? extends ProcessInfoKeyDescriptor> elements) {
            this.keys.clear();
            return this.addAllKeys(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeys(Iterable<? extends ProcessInfoKeyDescriptor> elements) {
            for (ProcessInfoKeyDescriptor processInfoKeyDescriptor : elements) {
                this.keys.add(Objects.requireNonNull(processInfoKeyDescriptor, "keys element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numDays(int numDays) {
            this.numDays = numDays;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ProcessIdInternalDecorationQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableProcessIdInternalDecorationQuery.validate(new ImmutableProcessIdInternalDecorationQuery(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("numDays");
            }
            return "Cannot build ProcessIdInternalDecorationQuery, some of required attributes are not set " + attributes;
        }
    }
}

