/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.plugins.monitoring.ProcessInfoKeyDescriptor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProcessInfoKeyDescriptor", generator="Immutables")
@Immutable
public final class ImmutableProcessInfoKeyDescriptor
extends ProcessInfoKeyDescriptor {
    private final String type;
    private final String key;
    private final String rename;
    @Nullable
    private final String formula;

    private ImmutableProcessInfoKeyDescriptor(Builder builder) {
        this.type = builder.type;
        this.key = builder.key;
        this.rename = builder.rename;
        this.formula = builder.formula;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String rename() {
        return this.rename;
    }

    @Override
    public Optional<String> formula() {
        return Optional.ofNullable(this.formula);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInfoKeyDescriptor && this.equalTo((ImmutableProcessInfoKeyDescriptor)another);
    }

    private boolean equalTo(ImmutableProcessInfoKeyDescriptor another) {
        return this.type.equals(another.type) && this.key.equals(another.key) && this.rename.equals(another.rename) && Objects.equals(this.formula, another.formula);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.rename.hashCode();
        h += (h << 5) + Objects.hashCode(this.formula);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProcessInfoKeyDescriptor{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("key=").append(this.key);
        builder.append(", ");
        builder.append("rename=").append(this.rename);
        if (this.formula != null) {
            builder.append(", ");
            builder.append("formula=").append(this.formula);
        }
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcessInfoKeyDescriptor", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private static final long INIT_BIT_RENAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String type;
        @Nullable
        private String key;
        @Nullable
        private String rename;
        @Nullable
        private String formula;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProcessInfoKeyDescriptor instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.key(instance.key());
            this.rename(instance.rename());
            Optional<String> formulaOptional = instance.formula();
            if (formulaOptional.isPresent()) {
                this.formula(formulaOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rename(String rename) {
            this.rename = Objects.requireNonNull(rename, "rename");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder formula(String formula) {
            this.formula = Objects.requireNonNull(formula, "formula");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder formula(Optional<String> formula) {
            this.formula = formula.orElse(null);
            return this;
        }

        public ProcessInfoKeyDescriptor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcessInfoKeyDescriptor(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("rename");
            }
            return "Cannot build ProcessInfoKeyDescriptor, some of required attributes are not set " + attributes;
        }
    }
}

