/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.MetricIntervals;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.StatsGraphDashboard;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsGraphDashboard", generator="Immutables")
@Immutable
public final class ImmutableStatsGraphDashboard
extends StatsGraphDashboard {
    private final Database db;
    private final ProcessIdDecorationTable processIds;
    @Nullable
    private final String since;
    private final MetricIntervals memory;
    private final MetricIntervals cpu;
    private final MetricIntervals gcCount;
    private final MetricIntervals gcTime;
    private final MetricIntervals memoryAllocated;
    private final MetricIntervals loggers;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStatsGraphDashboard(Builder builder) {
        this.db = builder.db;
        this.processIds = builder.processIds;
        this.since = builder.since;
        if (builder.memory != null) {
            this.initShim.memory(builder.memory);
        }
        if (builder.cpu != null) {
            this.initShim.cpu(builder.cpu);
        }
        if (builder.gcCount != null) {
            this.initShim.gcCount(builder.gcCount);
        }
        if (builder.gcTime != null) {
            this.initShim.gcTime(builder.gcTime);
        }
        if (builder.memoryAllocated != null) {
            this.initShim.memoryAllocated(builder.memoryAllocated);
        }
        if (builder.loggers != null) {
            this.initShim.loggers(builder.loggers);
        }
        this.memory = this.initShim.memory();
        this.cpu = this.initShim.cpu();
        this.gcCount = this.initShim.gcCount();
        this.gcTime = this.initShim.gcTime();
        this.memoryAllocated = this.initShim.memoryAllocated();
        this.loggers = this.initShim.loggers();
        this.initShim = null;
    }

    @Override
    public Database db() {
        return this.db;
    }

    @Override
    public ProcessIdDecorationTable processIds() {
        return this.processIds;
    }

    @Override
    public Optional<String> since() {
        return Optional.ofNullable(this.since);
    }

    @Override
    public MetricIntervals memory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.memory() : this.memory;
    }

    @Override
    public MetricIntervals cpu() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cpu() : this.cpu;
    }

    @Override
    public MetricIntervals gcCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gcCount() : this.gcCount;
    }

    @Override
    public MetricIntervals gcTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gcTime() : this.gcTime;
    }

    @Override
    public MetricIntervals memoryAllocated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.memoryAllocated() : this.memoryAllocated;
    }

    @Override
    public MetricIntervals loggers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.loggers() : this.loggers;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGraphDashboard && this.equalTo((ImmutableStatsGraphDashboard)another);
    }

    private boolean equalTo(ImmutableStatsGraphDashboard another) {
        return this.db.equals(another.db) && this.processIds.equals(another.processIds) && Objects.equals(this.since, another.since) && this.memory.equals(another.memory) && this.cpu.equals(another.cpu) && this.gcCount.equals(another.gcCount) && this.gcTime.equals(another.gcTime) && this.memoryAllocated.equals(another.memoryAllocated) && this.loggers.equals(another.loggers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.processIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.since);
        h += (h << 5) + this.memory.hashCode();
        h += (h << 5) + this.cpu.hashCode();
        h += (h << 5) + this.gcCount.hashCode();
        h += (h << 5) + this.gcTime.hashCode();
        h += (h << 5) + this.memoryAllocated.hashCode();
        h += (h << 5) + this.loggers.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StatsGraphDashboard{");
        builder.append("db=").append(this.db);
        builder.append(", ");
        builder.append("processIds=").append(this.processIds);
        if (this.since != null) {
            builder.append(", ");
            builder.append("since=").append(this.since);
        }
        builder.append(", ");
        builder.append("memory=").append(this.memory);
        builder.append(", ");
        builder.append("cpu=").append(this.cpu);
        builder.append(", ");
        builder.append("gcCount=").append(this.gcCount);
        builder.append(", ");
        builder.append("gcTime=").append(this.gcTime);
        builder.append(", ");
        builder.append("memoryAllocated=").append(this.memoryAllocated);
        builder.append(", ");
        builder.append("loggers=").append(this.loggers);
        return builder.append("}").toString();
    }

    private static ImmutableStatsGraphDashboard validate(ImmutableStatsGraphDashboard instance) {
        instance.checkUnits();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatsGraphDashboard", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_PROCESS_IDS = 2L;
        private long initBits = 3L;
        @Nullable
        private Database db;
        @Nullable
        private ProcessIdDecorationTable processIds;
        @Nullable
        private String since;
        @Nullable
        private MetricIntervals memory;
        @Nullable
        private MetricIntervals cpu;
        @Nullable
        private MetricIntervals gcCount;
        @Nullable
        private MetricIntervals gcTime;
        @Nullable
        private MetricIntervals memoryAllocated;
        @Nullable
        private MetricIntervals loggers;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StatsGraphDashboard instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.db());
            this.processIds(instance.processIds());
            Optional<String> sinceOptional = instance.since();
            if (sinceOptional.isPresent()) {
                this.since(sinceOptional);
            }
            this.memory(instance.memory());
            this.cpu(instance.cpu());
            this.gcCount(instance.gcCount());
            this.gcTime(instance.gcTime());
            this.memoryAllocated(instance.memoryAllocated());
            this.loggers(instance.loggers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(Database db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processIds(ProcessIdDecorationTable processIds) {
            this.processIds = Objects.requireNonNull(processIds, "processIds");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder since(String since) {
            this.since = Objects.requireNonNull(since, "since");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder since(Optional<String> since) {
            this.since = since.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memory(MetricIntervals memory) {
            this.memory = Objects.requireNonNull(memory, "memory");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cpu(MetricIntervals cpu) {
            this.cpu = Objects.requireNonNull(cpu, "cpu");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gcCount(MetricIntervals gcCount) {
            this.gcCount = Objects.requireNonNull(gcCount, "gcCount");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gcTime(MetricIntervals gcTime) {
            this.gcTime = Objects.requireNonNull(gcTime, "gcTime");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder memoryAllocated(MetricIntervals memoryAllocated) {
            this.memoryAllocated = Objects.requireNonNull(memoryAllocated, "memoryAllocated");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loggers(MetricIntervals loggers) {
            this.loggers = Objects.requireNonNull(loggers, "loggers");
            return this;
        }

        public StatsGraphDashboard build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStatsGraphDashboard.validate(new ImmutableStatsGraphDashboard(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("processIds");
            }
            return "Cannot build StatsGraphDashboard, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="StatsGraphDashboard", generator="Immutables")
    private final class InitShim {
        private byte memoryBuildStage = 0;
        private MetricIntervals memory;
        private byte cpuBuildStage = 0;
        private MetricIntervals cpu;
        private byte gcCountBuildStage = 0;
        private MetricIntervals gcCount;
        private byte gcTimeBuildStage = 0;
        private MetricIntervals gcTime;
        private byte memoryAllocatedBuildStage = 0;
        private MetricIntervals memoryAllocated;
        private byte loggersBuildStage = 0;
        private MetricIntervals loggers;

        private InitShim() {
        }

        MetricIntervals memory() {
            if (this.memoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.memoryBuildStage == 0) {
                this.memoryBuildStage = (byte)-1;
                this.memory = Objects.requireNonNull(ImmutableStatsGraphDashboard.super.memory(), "memory");
                this.memoryBuildStage = 1;
            }
            return this.memory;
        }

        void memory(MetricIntervals memory) {
            this.memory = memory;
            this.memoryBuildStage = 1;
        }

        MetricIntervals cpu() {
            if (this.cpuBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cpuBuildStage == 0) {
                this.cpuBuildStage = (byte)-1;
                this.cpu = Objects.requireNonNull(ImmutableStatsGraphDashboard.super.cpu(), "cpu");
                this.cpuBuildStage = 1;
            }
            return this.cpu;
        }

        void cpu(MetricIntervals cpu) {
            this.cpu = cpu;
            this.cpuBuildStage = 1;
        }

        MetricIntervals gcCount() {
            if (this.gcCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gcCountBuildStage == 0) {
                this.gcCountBuildStage = (byte)-1;
                this.gcCount = Objects.requireNonNull(ImmutableStatsGraphDashboard.super.gcCount(), "gcCount");
                this.gcCountBuildStage = 1;
            }
            return this.gcCount;
        }

        void gcCount(MetricIntervals gcCount) {
            this.gcCount = gcCount;
            this.gcCountBuildStage = 1;
        }

        MetricIntervals gcTime() {
            if (this.gcTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gcTimeBuildStage == 0) {
                this.gcTimeBuildStage = (byte)-1;
                this.gcTime = Objects.requireNonNull(ImmutableStatsGraphDashboard.super.gcTime(), "gcTime");
                this.gcTimeBuildStage = 1;
            }
            return this.gcTime;
        }

        void gcTime(MetricIntervals gcTime) {
            this.gcTime = gcTime;
            this.gcTimeBuildStage = 1;
        }

        MetricIntervals memoryAllocated() {
            if (this.memoryAllocatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.memoryAllocatedBuildStage == 0) {
                this.memoryAllocatedBuildStage = (byte)-1;
                this.memoryAllocated = Objects.requireNonNull(ImmutableStatsGraphDashboard.super.memoryAllocated(), "memoryAllocated");
                this.memoryAllocatedBuildStage = 1;
            }
            return this.memoryAllocated;
        }

        void memoryAllocated(MetricIntervals memoryAllocated) {
            this.memoryAllocated = memoryAllocated;
            this.memoryAllocatedBuildStage = 1;
        }

        MetricIntervals loggers() {
            if (this.loggersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.loggersBuildStage == 0) {
                this.loggersBuildStage = (byte)-1;
                this.loggers = Objects.requireNonNull(ImmutableStatsGraphDashboard.super.loggers(), "loggers");
                this.loggersBuildStage = 1;
            }
            return this.loggers;
        }

        void loggers(MetricIntervals loggers) {
            this.loggers = loggers;
            this.loggersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.memoryBuildStage == -1) {
                attributes.add("memory");
            }
            if (this.cpuBuildStage == -1) {
                attributes.add("cpu");
            }
            if (this.gcCountBuildStage == -1) {
                attributes.add("gcCount");
            }
            if (this.gcTimeBuildStage == -1) {
                attributes.add("gcTime");
            }
            if (this.memoryAllocatedBuildStage == -1) {
                attributes.add("memoryAllocated");
            }
            if (this.loggersBuildStage == -1) {
                attributes.add("loggers");
            }
            return "Cannot build StatsGraphDashboard, attribute initializers form cycle " + attributes;
        }
    }
}

