/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.MetricIntervalsTable;
import io.deephaven.plugins.monitoring.ProcessIdDecorationTable;
import io.deephaven.plugins.monitoring.StatsGraphQuery;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsGraphQuery", generator="Immutables")
@Immutable
public final class ImmutableStatsGraphQuery
extends StatsGraphQuery {
    private final Database db;
    private final ProcessIdDecorationTable processIds;
    private final MetricIntervalsTable metrics;
    @Nullable
    private final String since;

    private ImmutableStatsGraphQuery(Builder builder) {
        this.db = builder.db;
        this.processIds = builder.processIds;
        this.metrics = builder.metrics;
        this.since = builder.since;
    }

    @Override
    public Database db() {
        return this.db;
    }

    @Override
    public ProcessIdDecorationTable processIds() {
        return this.processIds;
    }

    @Override
    public MetricIntervalsTable metrics() {
        return this.metrics;
    }

    @Override
    public Optional<String> since() {
        return Optional.ofNullable(this.since);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGraphQuery && this.equalTo((ImmutableStatsGraphQuery)another);
    }

    private boolean equalTo(ImmutableStatsGraphQuery another) {
        return this.db.equals(another.db) && this.processIds.equals(another.processIds) && this.metrics.equals(another.metrics) && Objects.equals(this.since, another.since);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.processIds.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        h += (h << 5) + Objects.hashCode(this.since);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StatsGraphQuery{");
        builder.append("db=").append(this.db);
        builder.append(", ");
        builder.append("processIds=").append(this.processIds);
        builder.append(", ");
        builder.append("metrics=").append(this.metrics);
        if (this.since != null) {
            builder.append(", ");
            builder.append("since=").append(this.since);
        }
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatsGraphQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_PROCESS_IDS = 2L;
        private static final long INIT_BIT_METRICS = 4L;
        private long initBits = 7L;
        @Nullable
        private Database db;
        @Nullable
        private ProcessIdDecorationTable processIds;
        @Nullable
        private MetricIntervalsTable metrics;
        @Nullable
        private String since;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StatsGraphQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.db());
            this.processIds(instance.processIds());
            this.metrics(instance.metrics());
            Optional<String> sinceOptional = instance.since();
            if (sinceOptional.isPresent()) {
                this.since(sinceOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(Database db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processIds(ProcessIdDecorationTable processIds) {
            this.processIds = Objects.requireNonNull(processIds, "processIds");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metrics(MetricIntervalsTable metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder since(String since) {
            this.since = Objects.requireNonNull(since, "since");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder since(Optional<String> since) {
            this.since = since.orElse(null);
            return this;
        }

        public StatsGraphQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsGraphQuery(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("processIds");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("metrics");
            }
            return "Cannot build StatsGraphQuery, some of required attributes are not set " + attributes;
        }
    }
}

