/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.Table;
import io.deephaven.plugins.monitoring.StatsGraphQuery;
import io.deephaven.plugins.monitoring.StatsGraphResults;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsGraphResults", generator="Immutables")
@Immutable
public final class ImmutableStatsGraphResults
extends StatsGraphResults {
    private final StatsGraphQuery query;
    private final Table metrics;

    private ImmutableStatsGraphResults(Builder builder) {
        this.query = builder.query;
        this.metrics = builder.metrics;
    }

    @Override
    public StatsGraphQuery query() {
        return this.query;
    }

    @Override
    public Table metrics() {
        return this.metrics;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGraphResults && this.equalTo((ImmutableStatsGraphResults)another);
    }

    private boolean equalTo(ImmutableStatsGraphResults another) {
        return this.query.equals(another.query) && this.metrics.equals(another.metrics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        return h;
    }

    public String toString() {
        return "StatsGraphResults{query=" + this.query + ", metrics=" + this.metrics + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatsGraphResults", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long INIT_BIT_METRICS = 2L;
        private long initBits = 3L;
        @Nullable
        private StatsGraphQuery query;
        @Nullable
        private Table metrics;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StatsGraphResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.query(instance.query());
            this.metrics(instance.metrics());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder query(StatsGraphQuery query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metrics(Table metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public StatsGraphResults build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsGraphResults(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("query");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("metrics");
            }
            return "Cannot build StatsGraphResults, some of required attributes are not set " + attributes;
        }
    }
}

