/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.Table;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.MetricIntervalsTable;
import io.deephaven.plugins.monitoring.StatsQuery;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsQuery", generator="Immutables")
@Immutable
public final class ImmutableStatsQuery
extends StatsQuery {
    private final Database db;
    private final Table ticking;
    private final MetricIntervalsTable metrics;
    private final Table startupTime;

    private ImmutableStatsQuery(Builder builder) {
        this.db = builder.db;
        this.ticking = builder.ticking;
        this.metrics = builder.metrics;
        this.startupTime = builder.startupTime;
    }

    @Override
    public Database db() {
        return this.db;
    }

    @Override
    public Table ticking() {
        return this.ticking;
    }

    @Override
    public MetricIntervalsTable metrics() {
        return this.metrics;
    }

    @Override
    public Table startupTime() {
        return this.startupTime;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsQuery && this.equalTo((ImmutableStatsQuery)another);
    }

    private boolean equalTo(ImmutableStatsQuery another) {
        return this.db.equals(another.db) && this.ticking.equals(another.ticking) && this.metrics.equals(another.metrics) && this.startupTime.equals(another.startupTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.ticking.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        h += (h << 5) + this.startupTime.hashCode();
        return h;
    }

    public String toString() {
        return "StatsQuery{db=" + this.db + ", ticking=" + this.ticking + ", metrics=" + this.metrics + ", startupTime=" + this.startupTime + "}";
    }

    private static ImmutableStatsQuery validate(ImmutableStatsQuery instance) {
        instance.checkStartupTime();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatsQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_TICKING = 2L;
        private static final long INIT_BIT_METRICS = 4L;
        private static final long INIT_BIT_STARTUP_TIME = 8L;
        private long initBits = 15L;
        @Nullable
        private Database db;
        @Nullable
        private Table ticking;
        @Nullable
        private MetricIntervalsTable metrics;
        @Nullable
        private Table startupTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StatsQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.db());
            this.ticking(instance.ticking());
            this.metrics(instance.metrics());
            this.startupTime(instance.startupTime());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(Database db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ticking(Table ticking) {
            this.ticking = Objects.requireNonNull(ticking, "ticking");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metrics(MetricIntervalsTable metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startupTime(Table startupTime) {
            this.startupTime = Objects.requireNonNull(startupTime, "startupTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public StatsQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStatsQuery.validate(new ImmutableStatsQuery(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ticking");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("metrics");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("startupTime");
            }
            return "Cannot build StatsQuery, some of required attributes are not set " + attributes;
        }
    }
}

