/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.databases.Database;
import io.deephaven.plugins.monitoring.MetricIntervals;
import io.deephaven.plugins.monitoring.StatsQueryBasic;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsQueryBasic", generator="Immutables")
@Immutable
public final class ImmutableStatsQueryBasic
extends StatsQueryBasic {
    private final Database db;
    private final Duration tickInterval;
    private final Instant startupTime;
    private final MetricIntervals metrics;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStatsQueryBasic(Builder builder) {
        this.db = builder.db;
        if (builder.tickInterval != null) {
            this.initShim.tickInterval(builder.tickInterval);
        }
        if (builder.startupTime != null) {
            this.initShim.startupTime(builder.startupTime);
        }
        if (builder.metrics != null) {
            this.initShim.metrics(builder.metrics);
        }
        this.tickInterval = this.initShim.tickInterval();
        this.startupTime = this.initShim.startupTime();
        this.metrics = this.initShim.metrics();
        this.initShim = null;
    }

    @Override
    public Database db() {
        return this.db;
    }

    @Override
    public Duration tickInterval() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tickInterval() : this.tickInterval;
    }

    @Override
    public Instant startupTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.startupTime() : this.startupTime;
    }

    @Override
    public MetricIntervals metrics() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metrics() : this.metrics;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsQueryBasic && this.equalTo((ImmutableStatsQueryBasic)another);
    }

    private boolean equalTo(ImmutableStatsQueryBasic another) {
        return this.db.equals(another.db) && this.tickInterval.equals(another.tickInterval) && this.startupTime.equals(another.startupTime) && this.metrics.equals(another.metrics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.tickInterval.hashCode();
        h += (h << 5) + this.startupTime.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        return h;
    }

    public String toString() {
        return "StatsQueryBasic{db=" + this.db + ", tickInterval=" + this.tickInterval + ", startupTime=" + this.startupTime + ", metrics=" + this.metrics + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatsQueryBasic", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private long initBits = 1L;
        @Nullable
        private Database db;
        @Nullable
        private Duration tickInterval;
        @Nullable
        private Instant startupTime;
        @Nullable
        private MetricIntervals metrics;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StatsQueryBasic instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.db());
            this.tickInterval(instance.tickInterval());
            this.startupTime(instance.startupTime());
            this.metrics(instance.metrics());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(Database db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tickInterval(Duration tickInterval) {
            this.tickInterval = Objects.requireNonNull(tickInterval, "tickInterval");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startupTime(Instant startupTime) {
            this.startupTime = Objects.requireNonNull(startupTime, "startupTime");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metrics(MetricIntervals metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics");
            return this;
        }

        public StatsQueryBasic build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsQueryBasic(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            return "Cannot build StatsQueryBasic, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="StatsQueryBasic", generator="Immutables")
    private final class InitShim {
        private byte tickIntervalBuildStage = 0;
        private Duration tickInterval;
        private byte startupTimeBuildStage = 0;
        private Instant startupTime;
        private byte metricsBuildStage = 0;
        private MetricIntervals metrics;

        private InitShim() {
        }

        Duration tickInterval() {
            if (this.tickIntervalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tickIntervalBuildStage == 0) {
                this.tickIntervalBuildStage = (byte)-1;
                this.tickInterval = Objects.requireNonNull(ImmutableStatsQueryBasic.super.tickInterval(), "tickInterval");
                this.tickIntervalBuildStage = 1;
            }
            return this.tickInterval;
        }

        void tickInterval(Duration tickInterval) {
            this.tickInterval = tickInterval;
            this.tickIntervalBuildStage = 1;
        }

        Instant startupTime() {
            if (this.startupTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startupTimeBuildStage == 0) {
                this.startupTimeBuildStage = (byte)-1;
                this.startupTime = Objects.requireNonNull(ImmutableStatsQueryBasic.super.startupTime(), "startupTime");
                this.startupTimeBuildStage = 1;
            }
            return this.startupTime;
        }

        void startupTime(Instant startupTime) {
            this.startupTime = startupTime;
            this.startupTimeBuildStage = 1;
        }

        MetricIntervals metrics() {
            if (this.metricsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metricsBuildStage == 0) {
                this.metricsBuildStage = (byte)-1;
                this.metrics = Objects.requireNonNull(ImmutableStatsQueryBasic.super.metrics(), "metrics");
                this.metricsBuildStage = 1;
            }
            return this.metrics;
        }

        void metrics(MetricIntervals metrics) {
            this.metrics = metrics;
            this.metricsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.tickIntervalBuildStage == -1) {
                attributes.add("tickInterval");
            }
            if (this.startupTimeBuildStage == -1) {
                attributes.add("startupTime");
            }
            if (this.metricsBuildStage == -1) {
                attributes.add("metrics");
            }
            return "Cannot build StatsQueryBasic, attribute initializers form cycle " + attributes;
        }
    }
}

