/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugins.monitoring;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.illumon.iris.db.tables.utils.DBDateTime;
import io.deephaven.plugins.monitoring.Interval;
import io.deephaven.plugins.monitoring.StatsQueryDenormalizedKVFileWriter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsQueryDenormalizedKVFileWriter.SystemOutListenerKey", generator="Immutables")
@Immutable
public final class ImmutableSystemOutListenerKey
extends StatsQueryDenormalizedKVFileWriter.SystemOutListenerKey {
    private final String date;
    private final DBDateTime timestamp;
    private final String processId;
    private final Interval interval;
    @Nullable
    private final String host;
    @Nullable
    private final String processName;
    @Nullable
    private final Long pqSerial;
    @Nullable
    private final String pqOwner;
    @Nullable
    private final String pqName;
    @Nullable
    private final Long pqVersion;

    private ImmutableSystemOutListenerKey(Builder builder) {
        this.date = builder.date;
        this.timestamp = builder.timestamp;
        this.processId = builder.processId;
        this.interval = builder.interval;
        this.host = builder.host;
        this.processName = builder.processName;
        this.pqSerial = builder.pqSerial;
        this.pqOwner = builder.pqOwner;
        this.pqName = builder.pqName;
        this.pqVersion = builder.pqVersion;
    }

    @Override
    public String date() {
        return this.date;
    }

    @Override
    public DBDateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public String processId() {
        return this.processId;
    }

    @Override
    public Interval interval() {
        return this.interval;
    }

    @Override
    public Optional<String> host() {
        return Optional.ofNullable(this.host);
    }

    @Override
    public Optional<String> processName() {
        return Optional.ofNullable(this.processName);
    }

    @Override
    public OptionalLong pqSerial() {
        return this.pqSerial != null ? OptionalLong.of(this.pqSerial) : OptionalLong.empty();
    }

    @Override
    public Optional<String> pqOwner() {
        return Optional.ofNullable(this.pqOwner);
    }

    @Override
    public Optional<String> pqName() {
        return Optional.ofNullable(this.pqName);
    }

    @Override
    public OptionalLong pqVersion() {
        return this.pqVersion != null ? OptionalLong.of(this.pqVersion) : OptionalLong.empty();
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSystemOutListenerKey && this.equalTo((ImmutableSystemOutListenerKey)another);
    }

    private boolean equalTo(ImmutableSystemOutListenerKey another) {
        return this.date.equals(another.date) && this.timestamp.equals((Object)another.timestamp) && this.processId.equals(another.processId) && this.interval.equals((Object)another.interval) && Objects.equals(this.host, another.host) && Objects.equals(this.processName, another.processName) && Objects.equals(this.pqSerial, another.pqSerial) && Objects.equals(this.pqOwner, another.pqOwner) && Objects.equals(this.pqName, another.pqName) && Objects.equals(this.pqVersion, another.pqVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.date.hashCode();
        h += (h << 5) + this.timestamp.hashCode();
        h += (h << 5) + this.processId.hashCode();
        h += (h << 5) + this.interval.hashCode();
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.processName);
        h += (h << 5) + Objects.hashCode(this.pqSerial);
        h += (h << 5) + Objects.hashCode(this.pqOwner);
        h += (h << 5) + Objects.hashCode(this.pqName);
        h += (h << 5) + Objects.hashCode(this.pqVersion);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SystemOutListenerKey{");
        builder.append("date=").append(this.date);
        builder.append(", ");
        builder.append("timestamp=").append(this.timestamp);
        builder.append(", ");
        builder.append("processId=").append(this.processId);
        builder.append(", ");
        builder.append("interval=").append((Object)this.interval);
        if (this.host != null) {
            builder.append(", ");
            builder.append("host=").append(this.host);
        }
        if (this.processName != null) {
            builder.append(", ");
            builder.append("processName=").append(this.processName);
        }
        if (this.pqSerial != null) {
            builder.append(", ");
            builder.append("pqSerial=").append(this.pqSerial);
        }
        if (this.pqOwner != null) {
            builder.append(", ");
            builder.append("pqOwner=").append(this.pqOwner);
        }
        if (this.pqName != null) {
            builder.append(", ");
            builder.append("pqName=").append(this.pqName);
        }
        if (this.pqVersion != null) {
            builder.append(", ");
            builder.append("pqVersion=").append(this.pqVersion);
        }
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatsQueryDenormalizedKVFileWriter.SystemOutListenerKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_TIMESTAMP = 2L;
        private static final long INIT_BIT_PROCESS_ID = 4L;
        private static final long INIT_BIT_INTERVAL = 8L;
        private long initBits = 15L;
        @Nullable
        private String date;
        @Nullable
        private DBDateTime timestamp;
        @Nullable
        private String processId;
        @Nullable
        private Interval interval;
        @Nullable
        private String host;
        @Nullable
        private String processName;
        @Nullable
        private Long pqSerial;
        @Nullable
        private String pqOwner;
        @Nullable
        private String pqName;
        @Nullable
        private Long pqVersion;

        private Builder() {
        }

        public final Builder from(ImmutableSystemOutListenerKey instance) {
            return this.from((StatsQueryDenormalizedKVFileWriter.SystemOutListenerKey)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(StatsQueryDenormalizedKVFileWriter.SystemOutListenerKey instance) {
            OptionalLong pqVersionOptional;
            Optional<String> pqNameOptional;
            Optional<String> pqOwnerOptional;
            OptionalLong pqSerialOptional;
            Optional<String> processNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.date(instance.date());
            this.timestamp(instance.timestamp());
            this.processId(instance.processId());
            this.interval(instance.interval());
            Optional<String> hostOptional = instance.host();
            if (hostOptional.isPresent()) {
                this.host(hostOptional);
            }
            if ((processNameOptional = instance.processName()).isPresent()) {
                this.processName(processNameOptional);
            }
            if ((pqSerialOptional = instance.pqSerial()).isPresent()) {
                this.pqSerial(pqSerialOptional);
            }
            if ((pqOwnerOptional = instance.pqOwner()).isPresent()) {
                this.pqOwner(pqOwnerOptional);
            }
            if ((pqNameOptional = instance.pqName()).isPresent()) {
                this.pqName(pqNameOptional);
            }
            if ((pqVersionOptional = instance.pqVersion()).isPresent()) {
                this.pqVersion(pqVersionOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder date(String date) {
            this.date = Objects.requireNonNull(date, "date");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestamp(DBDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processId(String processId) {
            this.processId = Objects.requireNonNull(processId, "processId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder interval(Interval interval) {
            this.interval = Objects.requireNonNull(interval, "interval");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(Optional<String> host) {
            this.host = host.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processName(String processName) {
            this.processName = Objects.requireNonNull(processName, "processName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processName(Optional<String> processName) {
            this.processName = processName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqSerial(long pqSerial) {
            this.pqSerial = pqSerial;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqSerial(OptionalLong pqSerial) {
            this.pqSerial = pqSerial.isPresent() ? Long.valueOf(pqSerial.getAsLong()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqOwner(String pqOwner) {
            this.pqOwner = Objects.requireNonNull(pqOwner, "pqOwner");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqOwner(Optional<String> pqOwner) {
            this.pqOwner = pqOwner.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqName(String pqName) {
            this.pqName = Objects.requireNonNull(pqName, "pqName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqName(Optional<String> pqName) {
            this.pqName = pqName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqVersion(long pqVersion) {
            this.pqVersion = pqVersion;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pqVersion(OptionalLong pqVersion) {
            this.pqVersion = pqVersion.isPresent() ? Long.valueOf(pqVersion.getAsLong()) : null;
            return this;
        }

        public StatsQueryDenormalizedKVFileWriter.SystemOutListenerKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSystemOutListenerKey(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("processId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("interval");
            }
            return "Cannot build SystemOutListenerKey, some of required attributes are not set " + attributes;
        }
    }
}

